/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.domain.query.BalancingGroupQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.EntityLoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComXervLoadContext {
    public static final Logger LOG = LoggerFactory.getLogger(ComXervLoadContext.class);
    private final ApplicationContext appContext;
    private final Exchange exchange;
    private final AtomicBoolean errorPopupDisplayed;
    private final BackendConnectionGateway backendConnectionGateway;
    private final Duration dataLoadingIntervalDuration;

    public ComXervLoadContext(ApplicationContext appContext, Exchange exchange) {
        this.appContext = appContext;
        this.exchange = exchange;
        this.errorPopupDisplayed = new AtomicBoolean(false);
        this.backendConnectionGateway = appContext.getService(BackendConnectionGateway.class);
        this.dataLoadingIntervalDuration = Duration.standardHours(appContext.getService(ApplicationConfigurationService.class).getIntegerApplicationProperty("dataLoadingIntervalSplitHours", 24).intValue());
    }

    public Session getSession() {
        return this.backendConnectionGateway.getSession();
    }

    public boolean isSessionStillOpen() {
        return this.getSession() != null;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public UserRoles getUserRoles() {
        return this.appContext.getService(UserService.class).getOwnUserRoles();
    }

    public User getOwnUser() {
        return this.appContext.getService(UserService.class).getOwnUser();
    }

    public AbstractComXervExchangeConnection getConnection() {
        AbstractComXervExchangeConnection connection = (AbstractComXervExchangeConnection)this.getBackendConnectionGateway().getConnection();
        if (connection == null) {
            LOG.info("No connection found for the given session, it was probably just closed from another thread. {}", (Object)this.exchange);
        }
        return connection;
    }

    public void loadingError(RuntimeException e, Class<?> entityClass) {
        String message = "Loading " + entityClass.getSimpleName() + " failed. " + e.getMessage();
        LOG.error(message, e);
        AbstractComXervExchangeConnection connection = this.getConnection();
        if (!this.errorPopupDisplayed.getAndSet(true) && connection != null) {
            connection.forceLogoutAndOfferRelogin(message);
        }
    }

    public void additionalLoadingError(RuntimeException e, Class<?> entityClass) {
        String message = "Loading " + entityClass.getSimpleName() + " failed. " + e.getMessage();
        LOG.error(message, e);
        this.getMessagePublisher().publishMessage(Util.getLabel("historical_data_may_be_incomplete", entityClass.getSimpleName()), MessageSeverity.HIGH);
    }

    public DateTime getServerTime() {
        return this.appContext.getService(TimeService.class).getServerTime();
    }

    public <I extends Comparable<I>, T extends BroadcastEntity<I>> Stream<T> getAll(Class<T> clazz) {
        return this.appContext.getSmallDataModel(clazz).getAllEntitiesAsStream();
    }

    public EventBus getEventBus() {
        return this.appContext.getService(EventBus.class);
    }

    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    public BackendConnectionGateway getBackendConnectionGateway() {
        return this.backendConnectionGateway;
    }

    public <I extends Comparable<I>, T extends BroadcastEntity<I>> void loadingStarted(Class<T> entityClass) {
        this.getEventBus().post(new EntityLoadingStartedEvent<T>(entityClass));
    }

    public <I extends Comparable<I>, T extends BroadcastEntity<I>> void handleEntities(Class<T> entityClass, Collection<T> entities, boolean fireLoadingFinished) {
        FxUtil.runInFxThread(() -> {
            try {
                this.doHandleEntities(entityClass, entities);
            }
            finally {
                if (fireLoadingFinished) {
                    this.loadingFinished(entityClass);
                }
            }
        });
    }

    protected <I extends Comparable<I>, T extends BroadcastEntity<I>> void loadingFinished(Class<T> entityClass) {
        this.getEventBus().post(new EntityLoadingFinishedEvent<T>(entityClass));
    }

    private <I extends Comparable<I>, T extends BroadcastEntity<I>> void doHandleEntities(Class<T> entityClass, Collection<T> entities) {
        int entitySize;
        if (entities != null && (entitySize = entities.size()) > 0 && BroadcastEntity.class.isAssignableFrom(entityClass) && this.isSessionStillOpen()) {
            DataModel model = this.getAppContext().getDataModel(entityClass);
            LOG.trace("About to handle {} broadcast entities of {}", (Object)entitySize, (Object)entityClass);
            model.handleBroadcastEntities(entities);
        }
    }

    public <I extends Comparable<I>, T extends BroadcastEntity<I>> void additionalLoadingSuccess(Class<T> entityClass) {
        FxUtil.runInFxThread(() -> this.getMessagePublisher().publishMessage(Util.getLabel("historical_data_success", entityClass.getSimpleName()), MessageSeverity.LOW));
    }

    private MessagePublisher getMessagePublisher() {
        return this.appContext.getService(MessagePublisher.class);
    }

    public List<Interval> getTimeSlicesForRecentTrades() {
        DateTime serverTimeAtStartOfDay;
        DateTime serverTime = this.getServerTime();
        DateTime periodStart = serverTimeAtStartOfDay = serverTime.withTimeAtStartOfDay();
        DateTime periodEnd = serverTime.plusMinutes(10);
        return DateTimeUtils.split(periodStart, periodEnd, this.dataLoadingIntervalDuration);
    }

    public List<Interval> getTimeSlicesForHistoricalTrades() {
        DateTime serverTime = this.getServerTime();
        DateTime serverTimeAtStartOfDay = serverTime.withTimeAtStartOfDay();
        DateTime periodStart = serverTimeAtStartOfDay.minusDays(this.getExchange().getSystemInfo().getContractStoreTimeInDays()).toDateTime();
        DateTime periodEnd = serverTimeAtStartOfDay;
        return DateTimeUtils.split(periodStart, periodEnd, this.dataLoadingIntervalDuration);
    }

    public List<Interval> getTimeSlicesForContracts() {
        DateTime serverTime = this.getServerTime();
        DateTime serverTimeAtStartOfDay = serverTime.withTimeAtStartOfDay();
        DateTime periodStart = serverTimeAtStartOfDay.minusDays(this.getExchange().getSystemInfo().getContractStoreTimeInDays()).toDateTime();
        DateTime periodEnd = serverTimeAtStartOfDay.plusDays(this.getExchange().getContractLookAheadInDays()).toDateTime();
        return DateTimeUtils.split(periodStart, periodEnd, Duration.standardHours(24L));
    }

    public List<Interval> getTimeSlicesForHubToHub() {
        DateTime serverTimeAtStartOfDay;
        DateTime serverTime = this.getServerTime();
        DateTime periodStart = serverTimeAtStartOfDay = serverTime.withTimeAtStartOfDay();
        DateTime periodEnd = serverTimeAtStartOfDay.plusDays(1).plusMinutes(10);
        return DateTimeUtils.split(periodStart, periodEnd, Duration.standardDays(1L));
    }

    public Set<BalancingGroup> getBalancingGroupsFromUser() {
        UserService userService = this.appContext.getService(UserService.class);
        User ownUser = userService.getOwnUser();
        HashSet<String> bgIds = new HashSet<String>(ownUser.getBalancingGroupIds());
        if (ownUser.getRoles().isBroker()) {
            AssignmentService service = this.getAppContext().getService(AssignmentService.class);
            Set<String> brokerBgIds = service.getAssignedBgIdsForBroker(ownUser);
            bgIds.addAll(brokerBgIds);
        }
        return this.getAppContext().getService(BalancingGroupQueries.class).findByIds(bgIds).getAll().collect(Collectors.toSet());
    }

    public Set<String> getBalancingGroupIdsFromUser() {
        UserService userService = this.appContext.getService(UserService.class);
        User ownUser = userService.getOwnUser();
        HashSet<String> bgIds = new HashSet<String>(ownUser.getBalancingGroupIds());
        if (ownUser.getRoles().isBroker()) {
            AssignmentService service = this.getAppContext().getService(AssignmentService.class);
            Set<String> brokerBgIds = service.getAssignedBgIdsForBroker(ownUser);
            bgIds.addAll(brokerBgIds);
        }
        return bgIds;
    }
}

