/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadSingleEntityTypeTask;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import java.util.LinkedHashSet;
import java.util.Set;
import org.joda.time.DateTime;

public class LoadMessagesTask
extends LoadSingleEntityTypeTask<Message> {
    public static final int MESSAGE_HISTORY_IN_HOURS = 2;

    public LoadMessagesTask(ComXervLoadContext loadContext) {
        super(loadContext, Message.class);
    }

    @Override
    public Set<Message> load() {
        LinkedHashSet<Message> result = new LinkedHashSet<Message>();
        AbstractComXervExchangeConnection connection = this.getLoadContext().getConnection();
        if (connection != null) {
            for (String balancingGroupId : this.getLoadContext().getBalancingGroupIdsFromUser()) {
                DateTime endTime = this.getLoadContext().getServerTime().plusMinutes(10);
                DateTime startTime = endTime.minusHours(2);
                result.addAll(connection.getMessages(balancingGroupId, startTime, endTime));
            }
        }
        return result;
    }
}

