/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadSingleEntityTypeTask;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class LoadOrderbooksTask
extends LoadSingleEntityTypeTask<Orderbook> {
    public LoadOrderbooksTask(ComXervLoadContext loadContext) {
        super(loadContext, Orderbook.class, false);
    }

    @Override
    protected Set<Orderbook> load() {
        HashSet<Orderbook> result = new HashSet<Orderbook>();
        AbstractComXervExchangeConnection connection = this.getLoadContext().getConnection();
        if (connection != null) {
            if (this.getLoadContext().getOwnUser().getRoles().hasAssignments()) {
                AssignmentService assignmentService = this.getLoadContext().getAppContext().getService(AssignmentService.class);
                this.getLoadContext().getAll(DeliveryArea.class).filter(da -> assignmentService.isDeliveryAreaAssignedToUser(this.getLoadContext().getOwnUser(), (DeliveryArea)da)).forEach(da -> result.addAll(connection.getOrderbooks((DeliveryArea)da, da.getProductIds().stream().filter(productId -> assignmentService.isProductAssignedToUser((String)productId, this.getLoadContext().getOwnUser())).collect(Collectors.toSet()))));
            } else {
                this.getLoadContext().getAll(DeliveryArea.class).forEach(da -> result.addAll(connection.getOrderbooks((DeliveryArea)da, da.getProductIds())));
            }
        }
        return result;
    }
}

