/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.ComXervLoadContext;
import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.load.LoadSingleEntityTypeTask;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.UserRoles;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class LoadUsersTask
extends LoadSingleEntityTypeTask<User> {
    public LoadUsersTask(ComXervLoadContext loadContext) {
        super(loadContext, User.class);
    }

    @Override
    protected Set<User> load() {
        Set<User> result = new HashSet<User>();
        UserRoles userRoles = this.getLoadContext().getUserRoles();
        boolean hasAdminRole = userRoles.isAdmin() || userRoles.isSalesUser();
        boolean hasProperRole = hasAdminRole || userRoles.isOnBehalf() || userRoles.isBroker() || userRoles.isTrader();
        AbstractComXervExchangeConnection connection = this.getLoadContext().getConnection();
        if (hasProperRole && connection != null) {
            if (hasAdminRole) {
                result.addAll(connection.getAllUsers());
            } else {
                Set<String> memberIds = userRoles.isBroker() ? this.getAllMembers() : Collections.singleton(this.getLoadContext().getOwnUser().getMemberId());
                result.addAll(connection.getUsersForMembers(memberIds));
            }
        }
        if (!result.isEmpty()) {
            result = this.excludeOwnUser(result);
        }
        return result;
    }

    private Set<String> getAllMembers() {
        return this.getLoadContext().getAll(Member.class).map(BroadcastEntity::getId).collect(Collectors.toSet());
    }

    private Set<User> excludeOwnUser(Set<User> users) {
        return users.stream().filter(input -> input != null && !input.equals(this.getLoadContext().getOwnUser())).collect(Collectors.toSet());
    }
}

