/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.hint.HubToHubHint;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.AccChangeRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.AcctInfoRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.CashLmtRprtNotifyListenersObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.CommodityLmtRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.ContractInfoRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.DlvryAreaInfoRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.ErrRespNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.HubToHubNtfNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.LogoutRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.MbrChangeRprtObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.MsgRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.OrdrExeRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.OrdrLmtRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.PblcOrdrBooksDeltaRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.PblcTradeConfRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.ProdInfoRprtHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.RefPxRprtNotifyListenersObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.StlmntProcessInfoRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.TradeCaptureRprtNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener.UserRprtObjectHandler;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.AccountMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.BasketRestrictionMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.CommodityLimitMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.ContractMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.CurrentLimitMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.DeliveryAreaMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.ErrorCodeMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.ErrorTypeMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.ErrorTypeMessageMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.FullTradeMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.FullUserTypeMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.H2HAreaMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.HubToHubHeartbeatMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.HubToHubMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.ListExecInstTypeMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.LogoutNotificationMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.MarketAreaMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.MarketStateMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.MemberChangeMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.MemberMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.MessageMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.OrderEntryTypeMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.OrderLimitMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.OrderModificationTypeMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.OrderbookMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.OrdrListEntryTypeMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.ProductMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.PublicAccountMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.PublicTradeConfirmationMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.ReferencePriceMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.RiskSetMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.SystemInfoMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.TradeResponseMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.TradeSettlementMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.TradingLimitDeltaMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.TradingLimitMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.UserRprtOwnUserMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.UserRprtUserMapper;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.UserTypeMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.SystemInfo;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.H2HArea;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.MarketState;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.OwnUser;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.entities.RiskSet;
import com.deutscheboerse.comxerv.comtrader.entities.TradeSettlement;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.SpecialMessage;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpBroadcastClassifier;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectRouter;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.event.LoginEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.OwnUserLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionMismatchAlertService;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.ErrorCodeAndKey;
import com.deutscheboerse.m7.trading.api.Request;
import com.deutscheboerse.m7.trading.api.v6.AcctChangeRprt;
import com.deutscheboerse.m7.trading.api.v6.AcctInfoReq;
import com.deutscheboerse.m7.trading.api.v6.AcctInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.AllMbrsReq;
import com.deutscheboerse.m7.trading.api.v6.AllMbrsResp;
import com.deutscheboerse.m7.trading.api.v6.AllUsersReq;
import com.deutscheboerse.m7.trading.api.v6.AllUsersResp;
import com.deutscheboerse.m7.trading.api.v6.CashLmtReq;
import com.deutscheboerse.m7.trading.api.v6.CashLmtRprt;
import com.deutscheboerse.m7.trading.api.v6.CommodityLmtReq;
import com.deutscheboerse.m7.trading.api.v6.CommodityLmtRprt;
import com.deutscheboerse.m7.trading.api.v6.CommodityLmtType;
import com.deutscheboerse.m7.trading.api.v6.ContractInfoReq;
import com.deutscheboerse.m7.trading.api.v6.ContractInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.ContractType;
import com.deutscheboerse.m7.trading.api.v6.DlvryAreaInfoReq;
import com.deutscheboerse.m7.trading.api.v6.DlvryAreaInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.DlvryAreaListEntryType;
import com.deutscheboerse.m7.trading.api.v6.ErrResp;
import com.deutscheboerse.m7.trading.api.v6.ErrorType;
import com.deutscheboerse.m7.trading.api.v6.ExistingUserType;
import com.deutscheboerse.m7.trading.api.v6.FullProdInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.H2HAreaInfoReq;
import com.deutscheboerse.m7.trading.api.v6.H2HAreaInfoResp;
import com.deutscheboerse.m7.trading.api.v6.H2HAreaListEntryType;
import com.deutscheboerse.m7.trading.api.v6.H2HAreaListType;
import com.deutscheboerse.m7.trading.api.v6.HubFromType;
import com.deutscheboerse.m7.trading.api.v6.HubToHubAtcData;
import com.deutscheboerse.m7.trading.api.v6.HubToHubNtf;
import com.deutscheboerse.m7.trading.api.v6.HubToHubReq;
import com.deutscheboerse.m7.trading.api.v6.HubToHubResp;
import com.deutscheboerse.m7.trading.api.v6.LoginReq;
import com.deutscheboerse.m7.trading.api.v6.LogoutReq;
import com.deutscheboerse.m7.trading.api.v6.LogoutRprt;
import com.deutscheboerse.m7.trading.api.v6.MbrChangeRprt;
import com.deutscheboerse.m7.trading.api.v6.MbrListType;
import com.deutscheboerse.m7.trading.api.v6.MbrType;
import com.deutscheboerse.m7.trading.api.v6.MbrVolumeType;
import com.deutscheboerse.m7.trading.api.v6.MktAreaInfoReq;
import com.deutscheboerse.m7.trading.api.v6.MktAreaInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.MktAreaListEntryType;
import com.deutscheboerse.m7.trading.api.v6.MktAreaListType;
import com.deutscheboerse.m7.trading.api.v6.MktStateReq;
import com.deutscheboerse.m7.trading.api.v6.MktStateRprt;
import com.deutscheboerse.m7.trading.api.v6.MsgReq;
import com.deutscheboerse.m7.trading.api.v6.MsgRprt;
import com.deutscheboerse.m7.trading.api.v6.MsgType;
import com.deutscheboerse.m7.trading.api.v6.OrderbookApiVersionType;
import com.deutscheboerse.m7.trading.api.v6.OrderbookBatchingType;
import com.deutscheboerse.m7.trading.api.v6.OrdrExeRprt;
import com.deutscheboerse.m7.trading.api.v6.OrdrLmtReq;
import com.deutscheboerse.m7.trading.api.v6.OrdrLmtRprt;
import com.deutscheboerse.m7.trading.api.v6.OrdrReq;
import com.deutscheboerse.m7.trading.api.v6.PblcOrdrBooksDeltaRprt;
import com.deutscheboerse.m7.trading.api.v6.PblcOrdrBooksReq;
import com.deutscheboerse.m7.trading.api.v6.PblcOrdrBooksResp;
import com.deutscheboerse.m7.trading.api.v6.PblcTradeConfReq;
import com.deutscheboerse.m7.trading.api.v6.PblcTradeConfRprt;
import com.deutscheboerse.m7.trading.api.v6.ProdInfoReq;
import com.deutscheboerse.m7.trading.api.v6.ProdInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.ProdType;
import com.deutscheboerse.m7.trading.api.v6.RefPxReq;
import com.deutscheboerse.m7.trading.api.v6.RefPxRprt;
import com.deutscheboerse.m7.trading.api.v6.ReportRiskSetListEntryType;
import com.deutscheboerse.m7.trading.api.v6.ReportRiskSetListType;
import com.deutscheboerse.m7.trading.api.v6.RiskSetInfoReq;
import com.deutscheboerse.m7.trading.api.v6.RiskSetInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.StandardHeaderType;
import com.deutscheboerse.m7.trading.api.v6.StlmntProcessInfoReq;
import com.deutscheboerse.m7.trading.api.v6.StlmntProcessInfoRprt;
import com.deutscheboerse.m7.trading.api.v6.SystemInfoReq;
import com.deutscheboerse.m7.trading.api.v6.SystemInfoResp;
import com.deutscheboerse.m7.trading.api.v6.TradeCaptureReq;
import com.deutscheboerse.m7.trading.api.v6.TradeCaptureRprt;
import com.deutscheboerse.m7.trading.api.v6.UserRprt;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComXervExchangeConnection
extends AbstractComXervExchangeConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ComXervExchangeConnection.class);
    private final ObjectRouter objectRouter;
    private final VersionMismatchAlertService versionMismatchAlertService;
    private volatile UserRprt loginUserRprt;
    private final ObjectHandler<Object> objectHandler;

    public ComXervExchangeConnection(ApplicationContext appContext, ConnectionParametersWithFallback connectionParametersWithFallback) {
        super(appContext, connectionParametersWithFallback);
        this.versionMismatchAlertService = appContext.getService(VersionMismatchAlertService.class);
        this.initMappers(appContext);
        this.objectRouter = new ObjectRouter(this.broadcastHandler, this.mappers, appContext.getService(AmqpBroadcastClassifier.class, this.getExchange()));
        this.objectHandler = (session, object, correlationId) -> {
            try {
                this.objectRouter.handleObject(session, object, correlationId);
            }
            catch (Exception e) {
                LOG.error("Error handling " + String.valueOf(object) + " with correlation Id " + correlationId, e);
            }
            return ObjectHandler.Result.RETAIN;
        };
        this.initObjectRouter();
    }

    private void initMappers(ApplicationContext appContext) {
        this.mappers.addHandler(new AccountMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new BasketRestrictionMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new ReferencePriceMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new CommodityLimitMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new ContractMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new CurrentLimitMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new OrderLimitMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new DeliveryAreaMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new ErrorCodeMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new ErrorTypeMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new ErrorTypeMessageMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new FullTradeMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new FullUserTypeMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new HubToHubMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new ListExecInstTypeMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new LogoutNotificationMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new MarketAreaMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new H2HAreaMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new MarketStateMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new MemberChangeMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new MemberMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new MessageMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new OrderbookMapper(appContext, this.getExchange(), this));
        this.mappers.addHandler(new OrderEntryTypeMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new OrderModificationTypeMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new OrdrListEntryTypeMapper(appContext, this.getExchange(), this));
        this.mappers.addHandler(new ProductMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new PublicTradeConfirmationMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new PublicAccountMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new RiskSetMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new SystemInfoMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new TradeSettlementMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new TradingLimitMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new TradingLimitDeltaMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new TradeResponseMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new UserRprtOwnUserMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new UserRprtUserMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new UserTypeMapper(appContext, this.getExchange()));
        this.mappers.addHandler(new HubToHubHeartbeatMapper(appContext, this.getExchange()));
    }

    private String getMarketId() {
        return this.getConnectionParameters().getExchange().getMarketId();
    }

    private void initObjectRouter() {
        this.addObjectHandler(this.objectHandler);
        this.objectRouter.addHandler(MsgRprt.class, new MsgRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(PblcTradeConfRprt.class, new PblcTradeConfRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(ContractInfoRprt.class, new ContractInfoRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(RefPxRprt.class, new RefPxRprtNotifyListenersObjectHandler(this.broadcastHandler, this.appContext, this.mappers));
        this.objectRouter.addHandler(OrdrExeRprt.class, new OrdrExeRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(StlmntProcessInfoRprt.class, new StlmntProcessInfoRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(HubToHubNtf.class, new HubToHubNtfNotifyListenerObjectHandler(this.broadcastHandler, this.appContext, this.mappers));
        this.objectRouter.addHandler(PblcOrdrBooksDeltaRprt.class, new PblcOrdrBooksDeltaRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(TradeCaptureRprt.class, new TradeCaptureRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(LogoutRprt.class, new LogoutRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers, this.appContext));
        this.objectRouter.addHandler(CommodityLmtRprt.class, new CommodityLmtRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(OrdrLmtRprt.class, new OrdrLmtRprtNotifyListenerObjectHandler(this.broadcastHandler, this.appContext, this.mappers));
        this.objectRouter.addHandler(AcctInfoRprt.class, new AcctInfoRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers, this, this.appContext));
        this.objectRouter.addHandler(AcctChangeRprt.class, new AccChangeRprtNotifyListenerObjectHandler(this.broadcastHandler, this.appContext, this.mappers));
        this.objectRouter.addHandler(DlvryAreaInfoRprt.class, new DlvryAreaInfoRprtNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(ErrResp.class, new ErrRespNotifyListenerObjectHandler(this.broadcastHandler, this.mappers));
        this.objectRouter.addHandler(ProdInfoRprt.class, new ProdInfoRprtHandler(this, this.appContext));
        this.objectRouter.addHandler(UserRprt.class, new UserRprtObjectHandler(this.appContext, this));
        this.objectRouter.addHandler(MbrChangeRprt.class, new MbrChangeRprtObjectHandler(this.appContext, this));
        this.objectRouter.addHandler(CashLmtRprt.class, new CashLmtRprtNotifyListenersObjectHandler(this.broadcastHandler, this.appContext, this.mappers));
    }

    public StandardHeaderType createStandardHeader() {
        StandardHeaderType standardHeaderType = new StandardHeaderType();
        standardHeaderType.setMarketId(this.getMarketId());
        return standardHeaderType;
    }

    @Override
    public void logout() {
        try {
            if (this.isConnected()) {
                this.disconnecting();
                LogoutReq logoutReq = new LogoutReq();
                logoutReq.setSessionId(this.getSession().getRemoteId());
                logoutReq.setStandardHeader(this.createStandardHeader());
                this.sendRequest((Request)logoutReq, true, 60000);
                this.eventIndex = null;
            }
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    public void localLogout() {
        if (this.isConnected()) {
            this.disconnecting();
        }
        this.disconnect();
    }

    @Override
    public synchronized void disconnect() {
        super.disconnect();
        this.removeObjectHandler(this.objectHandler);
        this.eventIndex = null;
    }

    @Override
    public void login(Supplier<Boolean> forceLoginSupplier) throws LoginException {
        this.loginUserRprt = this.doLogin(forceLoginSupplier);
        OwnUser ownUser = this.getMapper().translate(OwnUser.class, this.loginUserRprt);
        this.getSession().init(this.loginUserRprt.getUsr().getSessionId());
        this.appContext.getDataModel(User.class).handleBroadcastEntity(ownUser);
        this.appContext.getService(EventBus.class).post(new OwnUserLoadedEvent(this.getSession(), ownUser));
        this.appContext.getService(EventBus.class).post(new LoginEvent(this.getSession()));
        if (!this.loginUserRprt.getStandardHeader().getMarketId().equals(this.getMarketId())) {
            try {
                this.logout();
            }
            catch (Exception e) {
                LOG.error("Could not log out.", e);
                throw new LoginException("Wrong exchange id.");
            }
        }
    }

    private UserRprt doLogin(Supplier<Boolean> forceLoginSupplier) throws LoginException {
        String strRespone;
        Object loginException;
        Object errorBuilder;
        Object errorMessage;
        Object object;
        ResponseWithCorrelationId responseWithCorrelationId;
        LoginReq loginRequest = new LoginReq();
        loginRequest.setStandardHeader(this.createStandardHeader());
        loginRequest.setUser(this.getConnectionParameters().getUsername());
        loginRequest.setAuthVerificationCode(this.getConnectionParameters().getVerificationCode());
        loginRequest.setForce(false);
        loginRequest.setDisconnectAction(EnumMapper.mapDisconnectAction(this.getConnectionParameters().getDisconnectAction()));
        loginRequest.setThrottlingUserAction(this.getConnectionParameters().getThrottlingUserAction());
        loginRequest.setThrottlingMemberAction(this.getConnectionParameters().getThrottlingMemberAction());
        if (this.getConnectionParameters().isUseShortOrderbookBatching()) {
            loginRequest.setOrderbookBatching(OrderbookBatchingType.SHORT);
        } else {
            loginRequest.setOrderbookBatching(OrderbookBatchingType.LONG);
        }
        if (!this.getConnectionParameters().isReceivePblcOrdrBooksDeltaRprt()) {
            loginRequest.setReceivePblcOrdrBooksDeltaRprt(Boolean.FALSE);
        }
        if (!this.getConnectionParameters().isReceivePblcTradeConfRprt()) {
            loginRequest.setReceivePblcTradeConfRprt(Boolean.FALSE);
        }
        if (this.getConnectionParameters().getOrderbookApiVersion() != null) {
            loginRequest.setOrderbookApiVersion(OrderbookApiVersionType.fromValue(this.getConnectionParameters().getOrderbookApiVersion()));
        }
        if (this.getConnectionParameters().getPrivateDataApiVersion() != null) {
            loginRequest.setPrivateDataApiVersion(OrderbookApiVersionType.fromValue(this.getConnectionParameters().getPrivateDataApiVersion()));
        }
        if (this.alreadyLoggedIn((responseWithCorrelationId = this.sendRequestAndReturnException(loginRequest, false)).getResponse())) {
            if (forceLoginSupplier.get().booleanValue()) {
                loginRequest.setForce(true);
                responseWithCorrelationId = this.sendRequestAndReturnException(loginRequest, false);
            } else {
                throw new LoginException("Login aborted by user.");
            }
        }
        if ((object = responseWithCorrelationId.getResponse()) instanceof UserRprt) {
            UserRprt userRprt = (UserRprt)object;
            if (!this.getMarketId().equals(userRprt.getStandardHeader().getMarketId())) {
                LOG.error("Market id mismatch (sent {}, received {})", (Object)this.getMarketId(), (Object)userRprt.getStandardHeader().getMarketId());
                errorMessage = "Login failed. Unexpected market id " + userRprt.getStandardHeader().getMarketId();
                throw new LoginException((String)errorMessage);
            }
            if (userRprt.getUsr().getConnectionLossMsg() != null) {
                this.publishMessage(MessageSeverity.LOW, userRprt.getUsr().getConnectionLossMsg(), SpecialMessage.FIRST_LOGIN_AFTER_CONNECTION_LOSS);
            }
            if (responseWithCorrelationId.getEventIndex() != null) {
                LOG.info("Received event-index: {}", (Object)responseWithCorrelationId.getEventIndex());
                this.eventIndex.set(responseWithCorrelationId.getEventIndex());
            } else {
                LOG.info("No event-index received.");
            }
            return userRprt;
        }
        errorMessage = responseWithCorrelationId.getResponse();
        if (errorMessage instanceof ErrResp) {
            ErrResp errResp = (ErrResp)errorMessage;
            errorBuilder = new StringBuilder();
            for (ErrorType error : errResp.getError()) {
                if (((StringBuilder)errorBuilder).length() > 0) {
                    ((StringBuilder)errorBuilder).append(" ");
                }
                ((StringBuilder)errorBuilder).append(error.getErr());
            }
            String errorMessage2 = ((StringBuilder)errorBuilder).toString();
            LOG.error(errorMessage2);
            this.publishMessage(MessageSeverity.ERROR, errorMessage2);
            throw new LoginException(errorMessage2);
        }
        errorBuilder = responseWithCorrelationId.getResponse();
        if (errorBuilder instanceof IOException) {
            IOException iOException = (IOException)errorBuilder;
            loginException = LoginException.fromIOException(iOException);
            LOG.error(((Throwable)loginException).getMessage());
            throw loginException;
        }
        loginException = responseWithCorrelationId.getResponse();
        if (loginException instanceof Exception) {
            Exception exception = (Exception)loginException;
            LOG.error("Unexpected kind of exception in login.", exception);
            errorMessage = "Login failed. " + exception.getMessage();
            throw new LoginException((String)errorMessage, exception);
        }
        errorMessage = responseWithCorrelationId.getResponse();
        if (errorMessage instanceof String && (strRespone = (String)errorMessage).toLowerCase().contains("version too low")) {
            LOG.error(strRespone);
            this.versionMismatchAlertService.showVersionMismatchError(strRespone);
            throw new LoginException(strRespone);
        }
        LOG.error("Unexpected login response: {}", responseWithCorrelationId.getResponse());
        errorMessage = "Login failed. " + String.valueOf(responseWithCorrelationId.getResponse() != null ? responseWithCorrelationId.getResponse() : "");
        throw new LoginException((String)errorMessage);
    }

    private boolean alreadyLoggedIn(Object response) {
        ErrResp errResp;
        return response instanceof ErrResp && (errResp = (ErrResp)response).getError() != null && !errResp.getError().isEmpty() && ErrorCodeAndKey.TRADER_ALREADY_LOGGED_IN_EXCEPTION.getErrorCode() == errResp.getError().get(0).getErrCode();
    }

    public Set<Contract> getContracts(Collection<Product> products, DateTime start, DateTime end) {
        HashSet<Contract> result = new HashSet<Contract>();
        ContractInfoReq contractInfoReq = new ContractInfoReq();
        contractInfoReq.setStandardHeader(this.createStandardHeader());
        products.stream().map(BroadcastEntity::getId).forEach(contractInfoReq.getProdName()::add);
        contractInfoReq.setStartDate(DateTimeUtils.mapDateTimeToDate(start));
        contractInfoReq.setEndDate(DateTimeUtils.mapDateTimeToDate(end));
        ContractInfoRprt contractInfoRprt = (ContractInfoRprt)this.sendRequest(contractInfoReq).getResponse();
        if (contractInfoRprt != null && contractInfoRprt.getContractList() != null) {
            result.addAll(this.mappers.translateSet(Contract.class, contractInfoRprt.getContractList().getContract()));
        }
        return result;
    }

    @Override
    public Set<Message> getMessages(String acctId, DateTime fromDate, DateTime toDate) {
        MsgReq msgReq = new MsgReq();
        msgReq.setStandardHeader(this.createStandardHeader());
        msgReq.setStartDate(DateTimeUtils.mapDateTimeToDate(fromDate));
        msgReq.setEndDate(DateTimeUtils.mapDateTimeToDate(toDate));
        msgReq.setAcctId(acctId);
        msgReq.setType(MsgType.ALL);
        MsgRprt response = (MsgRprt)this.sendRequest(msgReq).getResponse();
        if (response != null && response.getMsgList() != null) {
            return this.mappers.translateSet(Message.class, Lists.reverse(response.getMsgList().getMsg()));
        }
        return Collections.emptySet();
    }

    @Override
    public List<? extends BroadcastEntity<String>> getTradingLimit() {
        return this.getTradingLimit(this.getOwnUser().getMemberId());
    }

    @Override
    public List<? extends BroadcastEntity<String>> getTradingLimit(String memberId) {
        CashLmtReq trdLmtReq = new CashLmtReq();
        trdLmtReq.setStandardHeader(this.createStandardHeader());
        trdLmtReq.setMbrId(memberId);
        CashLmtRprt trdLmtResp = (CashLmtRprt)this.sendRequest(trdLmtReq).getResponse();
        Collection<? extends BroadcastEntity<String>> limits = new CashLmtRprtNotifyListenersObjectHandler(this.broadcastHandler, this.appContext, this.mappers).unpack(trdLmtResp, this.getExchange(), (String)null);
        return new ArrayList<BroadcastEntity<String>>(limits);
    }

    @Override
    public MarketState getMarketState() {
        MktStateReq mktStateReq = new MktStateReq();
        mktStateReq.setStandardHeader(this.createStandardHeader());
        MktStateRprt mktStateRprt = (MktStateRprt)this.sendRequest(mktStateReq).getResponse();
        return this.mappers.translate(MarketState.class, mktStateRprt);
    }

    @Override
    public SystemInfo getSystemInfo() {
        SystemInfoReq systemInfoReq = new SystemInfoReq();
        systemInfoReq.setStandardHeader(this.createStandardHeader());
        SystemInfoResp systemInfoResp = (SystemInfoResp)this.sendRequest(systemInfoReq).getResponse();
        return this.mappers.translate(SystemInfo.class, systemInfoResp);
    }

    @Override
    public Set<BalancingGroup> getBalancingGroups() {
        AcctInfoReq allAccountsReq = new AcctInfoReq();
        allAccountsReq.setStandardHeader(this.createStandardHeader());
        AcctInfoRprt acctInfoRprt = (AcctInfoRprt)this.sendRequest(allAccountsReq).getResponse();
        List accounts = acctInfoRprt == null || acctInfoRprt.getAcctList() == null ? Collections.emptyList() : acctInfoRprt.getAcctList().getAcct();
        return this.mappers.translateSet(BalancingGroup.class, accounts);
    }

    @Override
    public Set<Product> getProducts() {
        HashSet<Product> products;
        block4: {
            FullProdInfoRprt fullProdInfoRprt;
            Object resp;
            block3: {
                products = new HashSet<Product>();
                ProdInfoReq prodInfoReq = new ProdInfoReq();
                prodInfoReq.setStandardHeader(this.createStandardHeader());
                resp = this.sendRequest(prodInfoReq).getResponse();
                if (!(resp instanceof ProdInfoRprt)) break block3;
                ProdInfoRprt prodInfoRprt = (ProdInfoRprt)resp;
                if (prodInfoRprt.getProdList() == null) break block4;
                for (ProdType prodType : prodInfoRprt.getProdList().getProd()) {
                    Product product = this.mappers.translate(Product.class, prodType);
                    products.add(product);
                }
                break block4;
            }
            if (resp instanceof FullProdInfoRprt && (fullProdInfoRprt = (FullProdInfoRprt)resp).getProdList() != null) {
                for (ProdType prodType : fullProdInfoRprt.getProdList().getProd()) {
                    Product product = this.mappers.translate(Product.class, prodType);
                    products.add(product);
                }
            }
        }
        return products;
    }

    @Override
    public Set<MarketArea> getMarketAreas() {
        HashSet<MarketArea> result = new HashSet<MarketArea>();
        MktAreaInfoReq mktAreaInfoReq = new MktAreaInfoReq();
        mktAreaInfoReq.setStandardHeader(this.createStandardHeader());
        MktAreaInfoRprt mktAreaInfoRprt = (MktAreaInfoRprt)this.sendRequest(mktAreaInfoReq).getResponse();
        MktAreaListType mktAreaList = mktAreaInfoRprt.getMktAreaList();
        if (mktAreaList != null) {
            for (MktAreaListEntryType mktArea : mktAreaList.getMktArea()) {
                result.add(this.mappers.translate(MarketArea.class, mktArea));
            }
        }
        return result;
    }

    @Override
    public Set<H2HArea> getH2HAreas() {
        H2HAreaListType h2HMktAreaList;
        HashSet<H2HArea> result = new HashSet<H2HArea>();
        H2HAreaInfoReq h2HMktAreaInfoReq = new H2HAreaInfoReq();
        h2HMktAreaInfoReq.setStandardHeader(this.createStandardHeader());
        H2HAreaInfoResp h2HMktAreaInfoRprt = (H2HAreaInfoResp)this.sendRequest(h2HMktAreaInfoReq).getResponse();
        if (h2HMktAreaInfoRprt != null && (h2HMktAreaList = h2HMktAreaInfoRprt.getH2HAreaList()) != null) {
            for (H2HAreaListEntryType mktArea : h2HMktAreaList.getH2HArea()) {
                result.add(this.mappers.translate(H2HArea.class, mktArea));
            }
        }
        return result;
    }

    @Override
    public Set<DeliveryArea> getDeliveryAreas() {
        List<DlvryAreaListEntryType> dlvryAreaList;
        HashSet<DeliveryArea> result = new HashSet<DeliveryArea>();
        DlvryAreaInfoReq dlvryAreaInfoReq = new DlvryAreaInfoReq();
        dlvryAreaInfoReq.setStandardHeader(this.createStandardHeader());
        DlvryAreaInfoRprt dlvryAreaInfoRprt = (DlvryAreaInfoRprt)this.sendRequest(dlvryAreaInfoReq).getResponse();
        if (dlvryAreaInfoRprt != null && dlvryAreaInfoRprt.getDlvryAreaList() != null && (dlvryAreaList = dlvryAreaInfoRprt.getDlvryAreaList().getDlvryArea()) != null) {
            result.addAll(this.mappers.translateSet(DeliveryArea.class, dlvryAreaList));
        }
        return result;
    }

    @Override
    public Set<Member> getAllMembers() {
        HashSet<Member> result = new HashSet<Member>();
        AllMbrsReq allMembersReq = new AllMbrsReq();
        allMembersReq.setStandardHeader(this.createStandardHeader());
        AllMbrsResp allMembersResp = (AllMbrsResp)this.sendRequest(allMembersReq).getResponse();
        MbrListType mbrList = allMembersResp.getMbrList();
        if (mbrList != null) {
            for (MbrType member : mbrList.getMbr()) {
                result.add(this.mappers.translate(Member.class, member));
            }
        }
        return result;
    }

    @Override
    public Set<User> getAllUsers() {
        return this.getUsersForMembers(Collections.emptySet());
    }

    @Override
    public Set<User> getUsersForMembers(Set<String> memberIds) {
        HashSet<User> result = new HashSet<User>();
        AllUsersReq allUsersReq = new AllUsersReq();
        allUsersReq.setStandardHeader(this.createStandardHeader());
        for (String memberId : memberIds) {
            allUsersReq.getMbrId().add(memberId);
        }
        AllUsersResp allUsersResp = (AllUsersResp)this.sendRequest(allUsersReq).getResponse();
        if (allUsersResp != null && allUsersResp.getUsrList() != null) {
            for (ExistingUserType existingUserType : allUsersResp.getUsrList().getUsr()) {
                result.add(this.mappers.translate(User.class, existingUserType));
            }
        }
        return result;
    }

    @Override
    public Set<TradingLimit> getCommodityLimits() {
        HashSet<TradingLimit> tradingLimits = new HashSet<TradingLimit>();
        if (this.getExchange().supportsCommodityLimit()) {
            CommodityLmtReq commodityLmtReq = new CommodityLmtReq();
            commodityLmtReq.setStandardHeader(this.createStandardHeader());
            commodityLmtReq.setMbrId(this.getOwnUser().getMemberId());
            CommodityLmtRprt commodityLmtRprt = (CommodityLmtRprt)this.sendRequest(commodityLmtReq).getResponse();
            if (commodityLmtRprt != null && commodityLmtRprt.getCommodityLmtList() != null) {
                for (CommodityLmtType commodityLmt : commodityLmtRprt.getCommodityLmtList().getCommodityLmt()) {
                    tradingLimits.add(this.mappers.translate(TradingLimit.class, commodityLmt));
                }
            }
        }
        return tradingLimits;
    }

    @Override
    public Set<OrderLimit> getOrderLimits(Set<String> productIds) {
        HashSet<OrderLimit> orderLimits = new HashSet<OrderLimit>();
        OrdrLmtReq ordrLmtReq = new OrdrLmtReq();
        ordrLmtReq.setStandardHeader(this.createStandardHeader());
        ordrLmtReq.setMbrId(this.getOwnUser().getMemberId());
        ordrLmtReq.getProdName().addAll(productIds);
        OrdrLmtRprt ordrLmtRprt = (OrdrLmtRprt)this.sendRequest(ordrLmtReq).getResponse();
        if (ordrLmtRprt != null) {
            List<MbrVolumeType> mbr = ordrLmtRprt.getMbrList().getMbr();
            for (MbrVolumeType mbrVolumeType : mbr) {
                orderLimits.addAll(this.mappers.translateList(OrderLimit.class, mbrVolumeType.getOrdrLmtList().getOrdrLmt(), mbrVolumeType));
            }
            return orderLimits;
        }
        return new HashSet<OrderLimit>();
    }

    @Override
    public Set<Order> getOwnAndPreArrangedOrders() {
        OrdrReq ordrReq = new OrdrReq();
        ordrReq.setStandardHeader(this.createStandardHeader());
        ordrReq.setInclPreArranged(true);
        OrdrExeRprt ordrExeRpt = (OrdrExeRprt)this.sendRequest(ordrReq).getResponse();
        if (ordrExeRpt != null && ordrExeRpt.getOrdrList() != null) {
            return this.mappers.translateSet(Order.class, ordrExeRpt.getOrdrList().getOrdr());
        }
        return new HashSet<Order>();
    }

    @Override
    public Set<FullTrade> getTrades(Set<BalancingGroup> balancingGroups, DateTime periodFrom, DateTime periodTo) {
        HashSet<FullTrade> fullTrades = new HashSet<FullTrade>();
        if (this.isConnected()) {
            TradeCaptureReq tradeCaptureReq = new TradeCaptureReq();
            tradeCaptureReq.setStandardHeader(this.createStandardHeader());
            for (BalancingGroup balancingGroup : balancingGroups) {
                tradeCaptureReq.getAcctId().add((String)balancingGroup.getId());
            }
            tradeCaptureReq.setStartDate(DateTimeUtils.mapDateTimeToDate(periodFrom));
            tradeCaptureReq.setEndDate(DateTimeUtils.mapDateTimeToDate(periodTo));
            TradeCaptureRprt tradeCaptureRprt = (TradeCaptureRprt)this.sendRequest(tradeCaptureReq).getResponse();
            if (tradeCaptureRprt != null && tradeCaptureRprt.getTradeList() != null) {
                fullTrades.addAll(this.getMapper().translateList(FullTrade.class, tradeCaptureRprt.getTradeList().getTrade()));
            }
        }
        return fullTrades;
    }

    @Override
    public List<TradeSettlement> getTradeSettlementInfo(DateTime periodFrom, DateTime periodTo) {
        ArrayList<TradeSettlement> result = new ArrayList<TradeSettlement>();
        if (this.isConnected()) {
            StlmntProcessInfoReq stlmntProcessInfoReq = new StlmntProcessInfoReq();
            stlmntProcessInfoReq.setStandardHeader(this.createStandardHeader());
            stlmntProcessInfoReq.setStartDate(DateTimeUtils.mapDateTimeToDate(periodFrom));
            stlmntProcessInfoReq.setEndDate(DateTimeUtils.mapDateTimeToDate(periodTo));
            stlmntProcessInfoReq.setUnAcknOnly(false);
            stlmntProcessInfoReq.setLastOnly(true);
            StlmntProcessInfoRprt stlmntProcessInfoRprt = (StlmntProcessInfoRprt)this.sendRequest(stlmntProcessInfoReq).getResponse();
            if (stlmntProcessInfoRprt != null && stlmntProcessInfoRprt.getTrade() != null) {
                List<StlmntProcessInfoRprt.Trade> receivedTrades = stlmntProcessInfoRprt.getTrade();
                result.addAll(this.getMapper().translateList(TradeSettlement.class, receivedTrades));
            }
        }
        return result;
    }

    @Override
    public Set<PublicTradeConfirmation> getPublicTradeConfirmation(DateTime startDate, DateTime endDate) {
        HashSet<PublicTradeConfirmation> result = new HashSet<PublicTradeConfirmation>();
        PblcTradeConfReq pblcTradeConfReq = new PblcTradeConfReq();
        pblcTradeConfReq.setStandardHeader(this.createStandardHeader());
        pblcTradeConfReq.setStartDate(DateTimeUtils.mapDateTimeToDate(startDate));
        pblcTradeConfReq.setEndDate(DateTimeUtils.mapDateTimeToDate(endDate));
        PblcTradeConfRprt pblcTradeConfRprt = (PblcTradeConfRprt)this.sendRequest(pblcTradeConfReq).getResponse();
        if (pblcTradeConfRprt != null && pblcTradeConfRprt.getTradeList() != null) {
            result.addAll(this.mappers.translateSet(PublicTradeConfirmation.class, pblcTradeConfRprt.getTradeList().getPblcTradeConf()));
        }
        return result;
    }

    @Override
    public Set<HubToHub> getHubToHub(org.joda.time.LocalDate date) {
        HashSet<HubToHub> result = new HashSet<HubToHub>();
        this.appContext.getSmallDataModel(H2HArea.class).getAllEntitiesAsStream().forEach(ma -> result.addAll(this.getHubToHub(date, (String)ma.getId())));
        return result;
    }

    protected Set<HubToHub> getHubToHub(org.joda.time.LocalDate date, String areaId) {
        HubToHubReq hubToHubReq = new HubToHubReq();
        hubToHubReq.setStandardHeader(this.createStandardHeader());
        hubToHubReq.setDlvryDay(LocalDate.of(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth()));
        hubToHubReq.setArea(areaId);
        HubToHubResp hubToHubResp = (HubToHubResp)this.sendRequest(hubToHubReq).getResponse();
        if (hubToHubResp != null) {
            return this.getHubToHub(hubToHubResp.getHubToHubAtcList());
        }
        return Collections.emptySet();
    }

    protected Set<HubToHub> getHubToHub(List<HubToHubAtcData> list) {
        HashSet<HubToHub> result = new HashSet<HubToHub>();
        for (HubToHubAtcData hubToHubAtcData : list) {
            HubToHubHint hubToHubHint = new HubToHubHint(hubToHubAtcData.getDlvryStart(), hubToHubAtcData.getDlvryEnd(), hubToHubAtcData.getTimestmp());
            for (HubFromType hubFrom : hubToHubAtcData.getHubFrom()) {
                hubToHubHint.setFromMA(hubFrom.getFrm());
                hubToHubHint.setAtcDirection(HubToHubHint.AtcDirection.IN);
                result.addAll(this.mappers.translateSet(HubToHub.class, hubFrom.getAtc(), hubToHubHint));
                hubToHubHint.setAtcDirection(HubToHubHint.AtcDirection.OUT);
                result.addAll(this.mappers.translateSet(HubToHub.class, hubFrom.getAtc(), hubToHubHint));
            }
        }
        return result;
    }

    @Override
    public Set<Orderbook> getOrderbooks(DeliveryArea deliveryArea, Set<String> productIds) {
        if (productIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Orderbook> result = new HashSet<Orderbook>();
        PblcOrdrBooksReq pblcOrdrBookReq = new PblcOrdrBooksReq();
        pblcOrdrBookReq.setStandardHeader(this.createStandardHeader());
        pblcOrdrBookReq.getDlvryAreaId().add((String)deliveryArea.getId());
        pblcOrdrBookReq.getProdName().addAll(productIds);
        pblcOrdrBookReq.setContractType(ContractType.ALL);
        PblcOrdrBooksResp pblcOrdrBooksResp = (PblcOrdrBooksResp)this.sendRequest(pblcOrdrBookReq).getResponse();
        if (pblcOrdrBooksResp != null && pblcOrdrBooksResp.getOrdrbookList() != null) {
            result.addAll(this.mappers.translateSet(Orderbook.class, pblcOrdrBooksResp.getOrdrbookList().getOrdrBook()));
        }
        return result;
    }

    @Override
    public Set<RiskSet> getRiskSets() {
        HashSet<RiskSet> result = new HashSet<RiskSet>();
        RiskSetInfoReq riskSetInfoReq = new RiskSetInfoReq();
        riskSetInfoReq.setStandardHeader(this.createStandardHeader());
        RiskSetInfoRprt riskSetInfoRprt = (RiskSetInfoRprt)this.sendRequest(riskSetInfoReq).getResponse();
        ReportRiskSetListType riskSetList = riskSetInfoRprt.getRiskSetList();
        if (riskSetList != null) {
            for (ReportRiskSetListEntryType riskSet : riskSetList.getRiskSet()) {
                result.add(this.mappers.translate(RiskSet.class, riskSet));
            }
        }
        return result;
    }

    public Collection<Orderbook> getReferencePrices() {
        HashSet<Orderbook> result = Sets.newHashSet();
        RefPxReq refPxReq = new RefPxReq();
        refPxReq.setStandardHeader(this.createStandardHeader());
        RefPxRprt refPxRprt = (RefPxRprt)this.sendRequest(refPxReq).getResponse();
        if (refPxRprt != null && refPxRprt.getRefPxList() != null) {
            result.addAll(new RefPxRprtNotifyListenersObjectHandler(null, this.appContext, this.mappers).unpack(refPxRprt, this.getExchange(), (String)null));
        }
        return result;
    }

    @Override
    public int getLoggedInUserId() {
        return Optional.ofNullable(this.loginUserRprt).map(u -> u.getUsr().getUsrId()).orElse(-1);
    }

    public ObjectRouter getObjectRouter() {
        return this.objectRouter;
    }
}

