/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.AbstractComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.ProdInfoRprt;
import java.util.List;

public class ProdInfoRprtHandler
implements ObjectHandler<ProdInfoRprt> {
    private final MapperHandler mapper;
    private final BroadcastListenerHandlerForClass broadcastHandler;
    private final AbstractComXervExchangeConnection connection;
    private final DataModel<String, Product> productDataModel;

    public ProdInfoRprtHandler(AbstractComXervExchangeConnection connection, ApplicationContext applicationContext) {
        this.connection = connection;
        this.mapper = connection.getMapper();
        this.broadcastHandler = connection.getBroadcastHandler();
        this.productDataModel = applicationContext.getDataModel(Product.class);
    }

    @Override
    public ObjectHandler.Result handleObject(Session session, ProdInfoRprt object, String correlationId) {
        List<Product> products = this.mapper.translateList(Product.class, object.getProdList().getProd());
        boolean wasAnyProductModified = products.stream().anyMatch(this::isModifiedVersionOfExistingProduct);
        if (wasAnyProductModified) {
            this.connection.forceFullDataReload();
        } else {
            products.stream().forEach(this.broadcastHandler::notifyListeners);
        }
        return ObjectHandler.Result.RETAIN;
    }

    private boolean isModifiedVersionOfExistingProduct(Product product) {
        Product existingProduct = this.productDataModel.findById((String)product.getId());
        return existingProduct != null && existingProduct.hasRelevantProductSetupChanges(product);
    }
}

