/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.m7.trading.api.v6.AccountType;
import com.deutscheboerse.m7.trading.api.v6.RefDataStateType;
import org.apache.commons.lang3.BooleanUtils;

public class AccountMapper
extends AbstractMapper<AccountType, BalancingGroup> {
    private final boolean useBgIdAsName;

    public AccountMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, AccountType.class, BalancingGroup.class);
        this.useBgIdAsName = applicationContext.getService(ApplicationConfigurationService.class).getBooleanApplicationProperty("useBgIdAsName");
    }

    @Override
    public BalancingGroup translate(AccountType fromAccount, MapperHandler mapperHandler, Object hint) {
        String entityId = fromAccount.getAcctId();
        BalancingGroup balancingGroup = new BalancingGroup();
        balancingGroup.setId(entityId);
        User ownUser = this.applicationContext.getService(UserService.class).getOwnUser();
        balancingGroup.setDefault(entityId.equals(ownUser.getDefaultBalancingGroup()));
        balancingGroup.setRevisionNumber(fromAccount.getRevisionNo());
        balancingGroup.setName(this.useBgIdAsName ? entityId : fromAccount.getName());
        balancingGroup.setOtcTrading(BooleanUtils.toBoolean(fromAccount.isPreArrangedAvlbl()));
        balancingGroup.setSuspensionType(EnumMapper.mapSuspensionType((RefDataStateType)fromAccount.getState()));
        balancingGroup.setMemberId(fromAccount.getMbrId());
        balancingGroup.setDeliveryAreaIds(fromAccount.getDlvryAreaId());
        balancingGroup.setProductIds(fromAccount.getProdName());
        balancingGroup.setAssignedBgIds(fromAccount.getAssignedAcctIds());
        return balancingGroup;
    }
}

