/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.ComXervExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.hint.OrderHint;
import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.EnumMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.domain.query.UserQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.OrdrExeRprt;
import com.deutscheboerse.m7.trading.api.v6.OrdrListEntryType;
import com.deutscheboerse.m7.trading.api.v6.OrdrType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrdrListEntryTypeMapper
extends AbstractMapper<OrdrListEntryType, Order> {
    private static final Logger LOG = LoggerFactory.getLogger(OrdrListEntryTypeMapper.class);
    private final DataModel<String, BalancingGroup> balancingGroupDataModel;
    private final DataModel<String, DeliveryArea> deliveryAreaDataModel;
    private final DataModel<Long, Contract> contractDataModel;
    private final UserQueries userQueries;
    private final SmallFastDataModel<Integer, User> userDataModel;
    private final ComXervExchangeConnection connection;

    public OrdrListEntryTypeMapper(ApplicationContext applicationContext, Exchange exchange, ComXervExchangeConnection connection) {
        super(applicationContext, exchange, OrdrListEntryType.class, Order.class);
        this.connection = connection;
        this.balancingGroupDataModel = applicationContext.getDataModel(BalancingGroup.class);
        this.deliveryAreaDataModel = applicationContext.getDataModel(DeliveryArea.class);
        this.contractDataModel = applicationContext.getDataModel(Contract.class);
        this.userQueries = applicationContext.getService(UserQueries.class);
        this.userDataModel = applicationContext.getSmallDataModel(User.class);
    }

    @Override
    public Order translate(OrdrListEntryType from, MapperHandler mapperHandler, Object orderHint) {
        Contract contract = this.contractDataModel.findById(from.getContractId());
        if (contract == null) {
            LOG.error("The order {} has unknown contract {}", (Object)from.getOrdrId(), (Object)from.getContractId());
            if (!from.getOtherAttributes().containsKey(OBJECT_RETRY_KEY)) {
                this.retryOrdrListEntry(from, orderHint);
            }
            return null;
        }
        Order order = new Order();
        order.setId(from.getOrdrId());
        order.setDirection(EnumMapper.mapDirection(from.getSide()));
        if (from.getClearingAcctType() != null) {
            order.setAccount(from.getClearingAcctType());
        }
        order.setContract(contract);
        this.translateFromProduct(order, from);
        order.setStatus(EnumMapper.mapOrderStateType(from.getState()));
        order.setExecutionRestriction(EnumMapper.mapOrdrExeRestrictionType(from.getOrdrExeRestriction()));
        order.setText(from.getTxt());
        order.setLocation(from.getLocation());
        order.setMarketBased(from.isMarketBased());
        order.setContractReference(from.getContractReference());
        order.setFacilityType(from.getFacilityType());
        order.setUsageFraction(from.getUsageFraction());
        DeliveryArea deliveryArea = this.deliveryAreaDataModel.findById(from.getDlvryAreaId());
        order.setDeliveryArea(deliveryArea);
        order.setPreArrangedBalancingGroup(this.balancingGroupDataModel.findById(from.getPreArrangedAcct()));
        BalancingGroup balancingGroup = this.balancingGroupDataModel.findById(from.getAcctId());
        if (balancingGroup != null) {
            String memberId = balancingGroup.getMemberId();
            User user = this.userQueries.findByMemberIdAndCode(memberId, from.getUsrCode()).getFirst().orElse(null);
            order.setUser(user);
            order.setMemberCode(memberId);
            order.setBalancingGroup(balancingGroup);
        }
        order.setBrokerUserId(from.getBrokerUsrId());
        if (orderHint instanceof OrderHint) {
            order.setCorrelationId(((OrderHint)orderHint).getCorrelationId());
            Integer onBehalfUserId = ((OrderHint)orderHint).getOnBehalfUserId();
            if (onBehalfUserId != null) {
                User onBehalfUser = (User)this.userDataModel.findById(onBehalfUserId);
                if (onBehalfUser != null) {
                    order.setOnBehalfUser(onBehalfUser);
                } else {
                    LOG.error("The order {} has unknown onBehalfUser {}", (Object)from.getOrdrId(), (Object)onBehalfUserId);
                }
            }
        }
        order.setValidityDate(DateTimeUtils.mapDateToDateTime(from.getValidityDate(), this.getExchange().getSystemInfo().getTimeZone()));
        order.setValidityRestriction(EnumMapper.mapValidityRestrictionType(from.getValidityRes()));
        if (from.getTimestmp() != null) {
            order.setTimeStamp(DateTimeUtils.mapDateToDateTime(from.getTimestmp(), this.getExchange().getSystemInfo().getTimeZone()));
        }
        if (from.getLastUpdateTm() != null) {
            order.setLastUpdateTimeStamp(DateTimeUtils.mapDateToDateTime(from.getLastUpdateTm(), this.getExchange().getSystemInfo().getTimeZone()));
        }
        order.setOrderType(EnumMapper.mapOrdrType(from.getType(), from.isPreArranged()));
        order.setInitialOrderId(String.valueOf(from.getInitialOrdrId()));
        order.setRevisionNumber(from.getRevisionNo());
        order.setTraderUserCode(from.getUsrCode());
        order.setClientOrderId(from.getClOrdrId());
        order.setOpenOrClose(EnumMapper.mapOpenCloseIndType(from.getOpenCloseInd()));
        order.setModificationType(EnumMapper.mapAction(from.getAction()));
        order.setLastUpdateUser(from.getLastUpdateUsrInfo());
        order.setAot(from.isAot());
        order.setPreAotId(from.getPreAotId());
        return order;
    }

    private void translateFromProduct(Order order, OrdrListEntryType from) {
        Product product = order.getProduct();
        if (from.getType() == OrdrType.I) {
            order.setPeakQuantity(product.mapQuantityFromBackend(from.getDisplayQty()));
            order.setRemainingQuantity(product.mapQuantityFromBackend(from.getQty() + from.getHiddenQty()));
            order.setPeakPriceDelta(product.mapPriceFromBackend(from.getPpd()));
        } else {
            order.setRemainingQuantity(product.mapQuantityFromBackend(from.getQty()));
        }
        order.setInitialQuantity(product.mapQuantityFromBackend(from.getInitialQty()));
        order.setShownQuantity(product.mapQuantityFromBackend(from.getQty()));
        order.setLimitPrice(product.mapPriceFromBackend(from.getPx()));
        order.setStopPrice(product.mapPriceFromBackend(from.getStopPx()));
    }

    private void retryOrdrListEntry(OrdrListEntryType from, Object orderHint) {
        from.getOtherAttributes().put(OBJECT_RETRY_KEY, null);
        OrdrExeRprt ordrExeRprt = new OrdrExeRprt();
        ordrExeRprt.setOrdrList(new OrdrExeRprt.OrdrList());
        ordrExeRprt.getOrdrList().getOrdr().add(from);
        String correlationId = null;
        if (orderHint instanceof OrderHint) {
            correlationId = ((OrderHint)orderHint).getCorrelationId();
            ordrExeRprt.setStandardHeader(this.connection.createStandardHeader());
            ordrExeRprt.getStandardHeader().setOnBehalfUserId(((OrderHint)orderHint).getOnBehalfUserId());
        }
        this.connection.getObjectRouter().addRetryObject(ordrExeRprt, correlationId);
    }
}

