/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.util.DateTimeUtils;
import com.deutscheboerse.m7.trading.api.v6.RefPxListType;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencePriceMapper
extends AbstractMapper<RefPxListType.RefPx, Orderbook> {
    private static final Logger LOG = LoggerFactory.getLogger(ReferencePriceMapper.class);

    public ReferencePriceMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, RefPxListType.RefPx.class, Orderbook.class);
    }

    @Override
    public Orderbook translate(RefPxListType.RefPx from, MapperHandler mapperHandler, Object hint) {
        String deliveryAreaId = from.getDlvryAreaId();
        SmallFastDataModel<String, DeliveryArea> deliveryAreaDataModel = this.applicationContext.getSmallDataModel(DeliveryArea.class);
        DeliveryArea deliveryArea = (DeliveryArea)deliveryAreaDataModel.findById(deliveryAreaId);
        if (deliveryArea == null) {
            LOG.warn("Delivery area not found: {}", (Object)deliveryAreaId);
        }
        long contractId = from.getContractId();
        DataModel<Long, Contract> contractDataModel = this.applicationContext.getDataModel(Contract.class);
        Contract contract = contractDataModel.findById(contractId);
        if (contract == null) {
            LOG.warn("Contract not found: {}", (Object)contractId);
            return null;
        }
        Orderbook orderbook = new Orderbook(contract, deliveryArea, this.applicationContext.getService(OwnQuantityLookupService.class));
        Product product = contract.getProduct();
        orderbook.setId(deliveryAreaId + "|" + String.valueOf(contractId));
        DateTime refPriceDate = DateTimeUtils.mapDateToDateTime(from.getDate(), this.getExchange().getSystemInfo().getTimeZone());
        switch (from.getRefPxType()) {
            case C: {
                orderbook.setClosingPrice(product.mapPriceFromBackend(from.getRefPx()));
                orderbook.setClosingPriceDate(refPriceDate);
                break;
            }
            case O: {
                orderbook.setOpeningPrice(product.mapPriceFromBackend(from.getRefPx()));
                orderbook.setOpeningPriceDate(refPriceDate);
            }
        }
        orderbook.setRevisionNumber(Long.MAX_VALUE);
        return orderbook;
    }
}

