/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.datamodel.SmallFastDataModelBase;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Product;

public class ProductDataModel
extends SmallFastDataModelBase<String, Product> {
    private final ContractQueries contractQueries;

    public ProductDataModel(ApplicationContext applicationContext) {
        super(applicationContext);
        this.contractQueries = applicationContext.getService(ContractQueries.class);
        this.registerHencePostOperationListener(new AbstractDataModelListener<Product>(){

            @Override
            public DataModelListener.NotificationResult notifyUpdate(Product object) {
                ProductDataModel.this.contractQueries.findByProduct(object).getAll().forEach(contract -> contract.setProduct(object));
                return DataModelListener.NotificationResult.REMOVE_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        });
    }

    @Override
    public Class<Product> getEntityClass() {
        return Product.class;
    }
}

