/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.domain.filter;

import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductState;
import com.deutscheboerse.comxerv.comtrader.entities.type.ProductType;
import java.util.function.Predicate;

public class ProductFilters {
    public static final Predicate<Product> ALL_PRODUCTS_FILTER = product -> true;
    public static final Predicate<Product> ONLY_BLOCK_PRODUCTS_FILTER = product -> product.isBlockOrderProduct() || product.getProductType() == ProductType.USER_DEFINED_DELIVERY_PERIOD;
    public static final Predicate<Product> NON_OTC_NON_BLOCK_PRODUCTS_FILTER = product -> !product.isOtcOnlyProduct() && product.getProductType() != ProductType.USER_DEFINED_DELIVERY_PERIOD;
    public static final Predicate<Product> NON_OTC_PRODUCTS_FILTER = product -> !product.isOtcOnlyProduct();
    public static final Predicate<Product> ONLY_QUOTE_PRODUCTS_FILTER = Product::isQuoteOrderProduct;
    public static final Predicate<Product> ONLY_ACTIVE = product -> product.getProductState() == ProductState.ACTIVE;

    private ProductFilters() {
    }
}

