/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayImage;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.type.SuspensionType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DeliveryArea
extends BroadcastEntity<String>
implements SmallDataModelEntity,
Comparable<DeliveryArea>,
RevisionNumbered,
DisplayImage,
DisplayName,
Mergeable<DeliveryArea> {
    private final LongProperty revisionNumber = new SimpleLongProperty();
    private final ObjectProperty<SuspensionType> status = new SimpleObjectProperty<SuspensionType>();
    private SuspensionType remoteStatus = null;
    private final StringProperty marketAreaId = new SimpleStringProperty();
    private final ObjectProperty<MarketArea> marketArea;
    private final StringProperty name = new SimpleStringProperty();
    private Set<String> productIds;

    public DeliveryArea() {
        this((String)null);
    }

    public DeliveryArea(String id) {
        super(id);
        this.marketArea = new SimpleObjectProperty<MarketArea>();
        this.productIds = Collections.emptySet();
    }

    public LongProperty revisionNumberProperty() {
        return this.revisionNumber;
    }

    public ObjectProperty<SuspensionType> statusProperty() {
        return this.status;
    }

    public StringProperty marketAreaIdProperty() {
        return this.marketAreaId;
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public SuspensionType getStatus() {
        return (SuspensionType)((Object)this.status.get());
    }

    public void setStatus(SuspensionType status) {
        this.status.set(status);
    }

    public void setRemoteStatus(SuspensionType remoteStatus) {
        this.remoteStatus = remoteStatus;
    }

    public SuspensionType getRemoteStatus() {
        return this.remoteStatus;
    }

    public boolean isActiveOrSuspended() {
        return SuspensionType.ACTIVE == this.getStatus() || SuspensionType.SUSPEND == this.getStatus();
    }

    @Override
    public long getRevisionNumber() {
        return this.revisionNumber.get();
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber.set(revisionNumber);
    }

    public String getMarketAreaId() {
        return (String)this.marketAreaId.get();
    }

    public void setMarketAreaId(String marketAreaId) {
        this.marketAreaId.set(marketAreaId);
    }

    public MarketArea getMarketArea() {
        return (MarketArea)this.marketArea.get();
    }

    public ObjectProperty<MarketArea> marketAreaProperty() {
        return this.marketArea;
    }

    public void setMarketArea(MarketArea marketArea) {
        this.marketArea.set(marketArea);
    }

    public Set<String> getProductIds() {
        return Collections.unmodifiableSet(this.productIds);
    }

    public void setProductIds(Collection<String> productIds) {
        this.productIds = productIds == null ? Collections.emptySet() : new HashSet<String>(productIds);
    }

    public boolean containsProductId(String productId) {
        return this.productIds.contains(productId);
    }

    @Override
    public Class<DeliveryArea> getEntityClass() {
        return DeliveryArea.class;
    }

    @Override
    public int compareTo(DeliveryArea o) {
        return DisplayName.comparator().compare(this, o);
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.getId()).append("status", (Object)this.getStatus()).toString();
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    @Override
    public String getDisplayName() {
        return (String)this.name.get();
    }

    @Override
    public String getImagePath() {
        return Optional.ofNullable(this.getMarketArea()).map(MarketArea::getImagePath).orElse(null);
    }

    @Override
    public void merge(DeliveryArea otherDa) {
        this.setRevisionNumber(otherDa.getRevisionNumber());
        this.setStatus(otherDa.getStatus());
        this.setRemoteStatus(otherDa.getRemoteStatus());
        this.setProductIds(otherDa.getProductIds());
    }
}

