/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayImage;
import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import java.util.Map;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;

public class MarketArea
extends BroadcastEntity<String>
implements RevisionNumbered,
Mergeable<MarketArea>,
DisplayName,
DisplayImage,
SmallDataModelEntity,
Comparable<MarketArea> {
    private static final Map<String, String> FLAG_CODE_MAP = new UnifiedMap<String, String>();
    private String name;
    private String longName;
    private long revisionNumber;

    @Override
    public void merge(MarketArea marketArea) {
        this.setName(marketArea.getName());
        this.setLongName(marketArea.getLongName());
        this.setRevisionNumber(marketArea.getRevisionNumber());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    @Override
    public long getRevisionNumber() {
        return this.revisionNumber;
    }

    @Override
    public Class<MarketArea> getEntityClass() {
        return MarketArea.class;
    }

    public String getMarketAreaId() {
        return (String)this.getId();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getImagePath() {
        return "/com/deutscheboerse/comxerv/comtrader/flags/64x64/" + FLAG_CODE_MAP.getOrDefault(this.name, this.name) + ".png";
    }

    @Override
    public int compareTo(MarketArea o) {
        return DisplayName.comparator().compare(this, o);
    }

    public String toString() {
        return "MarketArea{name='" + this.name + "', longName='" + this.longName + "', revisionNumber=" + this.revisionNumber + "} " + super.toString();
    }

    static {
        FLAG_CODE_MAP.put("MA_NO1", "NO");
        FLAG_CODE_MAP.put("MA_NO2", "NO");
        FLAG_CODE_MAP.put("MA_NO3", "NO");
        FLAG_CODE_MAP.put("MA_NO4", "NO");
        FLAG_CODE_MAP.put("MA_NO5", "NO");
        FLAG_CODE_MAP.put("MA_SE1", "SE");
        FLAG_CODE_MAP.put("MA_SE2", "SE");
        FLAG_CODE_MAP.put("MA_SE3", "SE");
        FLAG_CODE_MAP.put("MA_SE4", "SE");
        FLAG_CODE_MAP.put("MA_FI", "FI");
        FLAG_CODE_MAP.put("MA_DK1", "DK");
        FLAG_CODE_MAP.put("MA_DK2", "DK");
        FLAG_CODE_MAP.put("MA_EE", "EE");
        FLAG_CODE_MAP.put("MA_LT", "LT");
        FLAG_CODE_MAP.put("MA_LV", "LV");
    }
}

