/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageType;

public enum StatusMessageType {
    MSG_UNKNOWN("unknown"),
    MSG_LOGIN("login", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_MS_LOGIN("login"),
    MSG_LOGOUT("logout"),
    MSG_USER_LOGIN_MONITORING("login"),
    MSG_BG_INACTIVE("balgroup_inactivated"),
    MSG_BG_INACTIVE_MS("balgroup_inactivated_ms"),
    MSG_ORDER_ENTERED("order.entered", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_ON_BEHALF_ENTERED_ADMIN("order.entered.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_ORDER_ON_BEHALF_ENTERED_USER("order.entered.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_MODIFIED("order.modified", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_ON_BEHALF_MODIFIED_ADMIN("order.modified.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_ORDER_ON_BEHALF_MODIFIED_USER("order.modified.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_MODIFY_ALREADY_EXECUTED("order.modify.already_executed", MessageSeverity.HIGH, MessageType.PUBLIC),
    MSG_ORDER_DELETED("order.deleted", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_ON_BEHALF_DELETED_ADMIN("order.deleted.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_ORDER_ON_BEHALF_DELETED_USER("order.deleted.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_INACTIVATE("order.inactivate", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_ON_BEHALF_INACTIVATE_ADMIN("order.inactivate.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_ORDER_ON_BEHALF_INACTIVATE_USER("order.inactivate.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_ENTERED_PREARRANGED("order.entered.pre", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_ENTERED_PREARRANGED_ON_BEHALF_ADMIN("order.entered.pre.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_ORDER_ENTERED_PREARRANGED_ON_BEHALF_USER("order.entered.pre.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_QUOTE_ENTERED("quote.entered", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_QUOTE_INDICATIVE_ENTERED("quote.indicative.entered", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_QUOTE_EXECUTED("quote.executed.completely", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_QUOTE_EXECUTED_PARTIAL("quote.executed.partial_remain", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_ORDER_RECEIVED_PREARRANGED("order.received.pre", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_DELETED_PREARRANGED("order.deleted.pre", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_DELETED_PREARRANGED_ON_BEHALF_ADMIN("order.deleted.pre.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_ORDER_DELETED_PREARRANGED_ON_BEHALF_USER("order.deleted.pre.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_REVOKED_PREARRANGED("order.revoked.pre", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_MODIFIED_PREARRANGED("order.modified.pre", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_MODIFIED_PREARRANGED_ON_BEHALF_ADMIN("order.modified.pre.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_ORDER_MODIFIED_PREARRANGED_ON_BEHALF_USER("order.modified.pre.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_REJECTED("order.rejected", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_REJECTED_BEHALF_ADMIN("order.rejected.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_ORDER_REJECTED_BEHALF_TARGET("order.rejected.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_REJECTED_BEHALF_ORIGINATOR("order.rejected.on_behalf.originator", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_ACCEPTED("order.accepted", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_ORDER_ACCEPTED_BEHALF_ADMIN("order.accepted.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_ORDER_ACCEPTED_BEHALF_TRADER("order.accepted.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_ACCEPTED_BEHALF_ORIGINATOR("order.accepted.on_behalf.originator", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_EXECUTED("order.executed.completely", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_ORDER_EXECUTED_PARTIAL("order.executed.partial_remain", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_ORDER_EXECUTED_PARTIAL_DELETED("order.executed.partial_deleted", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_ORDER_EXECUTED_DELETED("order.no_execution.deleted", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_TRADE_RECALL("trade.recall", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_TRADE_RECALL_BEHALF("trade.recall.on_behalf.user", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_TRADE_RECALL_PUBLIC("public_trade.recall", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_TRADE_RECALL_ACCEPTED("trade.recall.accepted", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_TRADE_RECALL_REJECTED("trade.recall.rejected", MessageSeverity.LOW, MessageType.PRIVATE),
    MSG_TRADE_RECALL_ACCEPTED_ADMIN("trade.recall.accepted"),
    MSG_TRADE_RECALL_REJECTED_ADMIN("trade.recall.rejected"),
    MSG_TRADE_RECALL_NOT_POSSIBLE("trade.recall.not_possible"),
    MSG_ADMIN_RECALL_TRADE("trade.recall.admin", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_ADMIN_RECALL_TRADE_ONBEHALF("trade.recall.on_behalf.admin", MessageSeverity.MEDIUM, MessageType.PRIVATE),
    MSG_CAPACITY_RECALL_FAILED("capacity_recall_failed"),
    MSG_CAPACITY_RECALL_POSSIBLE("capacity_recall_possible"),
    MSG_CAPACITY_RECALL_NOT_POSSIBLE("capacity_recall_not_possible"),
    MSG_CAPACITY_RECALL_NOT_POSSIBLE_GTC("capacity_recall_not_possible_gtc"),
    MSG_TRADE_PUBLIC("public_trade", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_SELF_TRADE_PUBLIC("public_self_trade", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_TRADE_PUBLIC_PREARRANGED("public_trade.pre", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_TRADE_PUBLIC_RECALL_ACCEPTED("public_trade.recall.accepted", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_TRADE_PUBLIC_RECALL_REJECTED("public_trade.recall.rejected", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_CONTRACT_CLOSED("contract.closed", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_CONTRACT_CLOSED_TSOS("x_contract_closed_tsos", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_CONTRACT_IN_BALANCING_PHASE("contract.in_balancing_phase"),
    MSG_CONTRACT_MODIFIED("contract.modified", MessageSeverity.HIGH, MessageType.PUBLIC),
    MSG_CONTRACT_MODIFIED_WITHOUT_PHASES("contract.modified.without_phases", MessageSeverity.HIGH, MessageType.PUBLIC),
    MSG_CONTRACT_MODIFICATION_CANCELLED("contract.modification.cancelled"),
    MSG_CONTRACT_HIBERNATED("contract_hibernated", MessageSeverity.HIGH, MessageType.PUBLIC),
    MSG_CONTRACT_ACTIVATED("contract_activated", MessageSeverity.HIGH, MessageType.PUBLIC),
    MSG_CONTRACT_HIBERNATED_PRIVATE("x_contract_hibernated_private", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_CONTRACT_ACTIVATED_PRIVATE("x_contract_activated_private", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_NOTPROCESSED_DUE_NOCHANGES("x_notprocessed_due_notchanges"),
    MSG_SUPERVISOR_GLOBAL("supervisor_message"),
    MSG_SUPERVISOR_MA("supervisor_message"),
    MSG_SUPERVISOR_PRIVATE("x_supervisor_message_private"),
    MSG_MARKET_HALT("market_halt", MessageSeverity.HIGH, MessageType.PUBLIC),
    MSG_MARKET_GO("market_go", MessageSeverity.HIGH, MessageType.PUBLIC),
    MSG_TRADING_PROCEDURE_CANCELLED("x_trading_procedure_cancelled"),
    MSG_HALT_PROCEDURE_CANCELLED("x_halt_procedure_cancelled"),
    MSG_STATUS_ALREADY_TRADING("x_status_already_trading"),
    MSG_STATUS_ALREADY_HALT("x_status_already_halt"),
    MSG_TSO_GO("tso_go", MessageSeverity.HIGH, MessageType.PUBLIC),
    MSG_TSO_HALT("tso_halt", MessageSeverity.HIGH, MessageType.PUBLIC),
    MSG_TSO_ALREADY_IN_HALT("x_tso_already_halt_private"),
    MSG_TSO_ALREADY_IN_TRADING("x_tso_already_trading_private"),
    MARKET_AREA_ALREADY_IN_HALT("marketArea_already_in_halt"),
    MARKET_AREA_ALREADY_IN_TRADING("marketArea_already_in_trading"),
    MSG_MARKET_SPLIT_AREA_CREATED("marketsplit_area_created"),
    MSG_MARKET_SPLIT_PERFORMED("marketsplit_performed"),
    MSG_PRODUCT_UPDATED("msg_product_updated"),
    MSG_PRODUCT_RELOADED("msg_product_reloaded"),
    MSG_PRODUCT_UPDATED_PRIVATE("msg_product_updated"),
    MSG_SUSPEND_PRIVATE("msg_suspend_private"),
    MSG_UNSUSPEND_PRIVATE("msg_unsuspend_private"),
    MSG_BG_SUSPEND_ADMIN("msg_bg_suspend_admin"),
    MSG_BG_UNSUSPEND_ADMIN("msg_bg_unsuspend_admin"),
    MSG_MEMBER_SUSPEND_ADMIN("msg_member_suspend_admin"),
    MSG_MEMBER_UNSUSPEND_ADMIN("msg_member_unsuspend_admin"),
    MSG_TEXT_ADMIN("text"),
    MSG_COB_AUCTION_STARTED("cob_auction_started"),
    MSG_COB_AUCTION_FINISHED("cob_auction_finished"),
    MSG_COB_AUCTION_RESULTS("cob_auction_results"),
    MSG_STATUS_CAPACITY_ALREADY_DISABLED("x_status_capacity_already_disabled"),
    MSG_STATUS_CAPACITY_ALREADY_ENABLED("x_status_capacity_already_enabled"),
    MSG_STATUS_CAPACITY_BORDER_ALREADY_DISABLED("x_status_capacity_border_already_disabled"),
    MSG_STATUS_CAPACITY_BORDER_ALREADY_ENABLED("x_status_capacity_border_already_enabled"),
    MSG_STATUS_CAPACITY_DISABLED("x_status_capacity_disabled"),
    MSG_STATUS_CAPACITY_ENABLED("x_status_capacity_enabled"),
    MSG_STATUS_CAPACITY_BORDER_DISABLED("x_status_capacity_border_disabled"),
    MSG_STATUS_CAPACITY_BORDER_ENABLED("x_status_capacity_border_enabled"),
    MSG_NO_CAPACITY_CONNECTION("capacity_disconnected"),
    MSG_TRADE_CANCELLED_PRIVATE_TRADER("trade_cancelled_private_trader"),
    MSG_TRADE_CANCELLED_PRIVATE_ADMIN("trade_cancelled_private_admin"),
    MSG_TRADE_CANCELLED_PUBLIC("trade_cancelled_public", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_LOGOUT_ACTION_TAKE_NO_ACTION("logout_action_no_action"),
    MSG_LOGOUT_ACTION_DEACTIVATE_MY_ORDERS("logout_action_deactivate_myorders"),
    MSG_LOGOUT_ACTION_DEACTIVATE_BG_ORDERS("logout_action_deactivate_bgorders"),
    MSG_CONN_LOSS_TAKE_NO_ACTION("connection_loss_no_action"),
    MSG_CONN_LOSS_DEACTIVATE_MY_ORDERS("connection_loss_deactivate_myorders"),
    MSG_CONN_LOSS_DEACTIVATE_BG_ORDERS("connection_loss_deactivate_bgorders"),
    MSG_CONN_LOSS_ADMIN("connection_loss_admin"),
    MSG_QUOTE_REQUEST_FOR_MA("quote_request", MessageSeverity.MEDIUM, MessageType.PUBLIC),
    MSG_NO_SOB_CONNECTION("sob_disconnected"),
    MSG_ORDER_TRIGGERED("order.triggered", MessageSeverity.HIGH, MessageType.PRIVATE),
    FAILOVER_EVENT("failover_event"),
    MSG_CONTRACT_CLOSING_REFERENCE_PRICE_CHANGED("x_contract_closing_price_changed", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_CONTRACT_OPENING_REFERENCE_PRICE_CHANGED("x_contract_opening_price_changed", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_AUCTION_FINISHED("auction_finished", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_AUCTION_FINISHED_NO_TRADE("auction_finished_no_trade", MessageSeverity.LOW, MessageType.PUBLIC),
    MSG_ORDER_DELETED_CA_INACTIVATED("order.deleted.ca_inactivated", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_ORDER_MODIFIED_CA_INACTIVATED("order.modified.ca_inactivated", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_STOP_ORDER_CONVERTED("order.stop_converted", MessageSeverity.HIGH, MessageType.PRIVATE),
    MSG_TIMEZONE_SETUP_DIFFERS("timezone_setup_differs");

    private final String key;
    private final MessageSeverity messageSeverity;
    private final MessageType messageType;

    private StatusMessageType(String key) {
        this.key = key;
        this.messageSeverity = MessageSeverity.LOW;
        this.messageType = MessageType.PRIVATE;
    }

    private StatusMessageType(String key, MessageSeverity messageSeverity, MessageType messageType) {
        this.key = key;
        this.messageSeverity = messageSeverity;
        this.messageType = messageType;
    }

    public String getKey() {
        return this.key;
    }

    public MessageSeverity getMessageSeverity() {
        return this.messageSeverity;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String toString() {
        return this.key;
    }
}

