/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.TradeSettlement;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeType;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.joda.time.DateTime;

public class TradeInfo {
    private final ObjectProperty<TradeState> tradeState;
    private long revisionNumber;
    private Contract contract;
    private LongDisplayValue price;
    private LongDisplayValue quantity;
    private DateTime timeStamp;
    private TradeType tradeType;
    private ContractPhase contractPhase;
    private boolean decomposed;
    private Long parentTradeId;
    private Long remoteTradeId;
    private final ObjectProperty<DateTime> recallRequestedTime;
    private final ObjectProperty<DateTime> recallGrantedTime;
    private final ObjectProperty<DateTime> recallLatestProcessTime;
    private final ObjectProperty<TradeSettlement> tradeSettlement;
    private boolean selfTrade;
    private final ObjectProperty<String> recallRequestor;
    private String location;

    public TradeInfo() {
        this.tradeState = new SimpleObjectProperty<TradeState>();
        this.timeStamp = null;
        this.recallRequestedTime = new SimpleObjectProperty<DateTime>();
        this.recallGrantedTime = new SimpleObjectProperty<DateTime>();
        this.recallLatestProcessTime = new SimpleObjectProperty<DateTime>();
        this.tradeSettlement = new SimpleObjectProperty<TradeSettlement>();
        this.decomposed = false;
        this.selfTrade = false;
        this.recallRequestor = new SimpleObjectProperty<String>();
        this.location = "";
    }

    public TradeInfo(TradeInfo trade) {
        this.tradeState = new SimpleObjectProperty<TradeState>((TradeState)trade.getTradeState().get());
        this.revisionNumber = trade.getRevisionNumber();
        this.contract = trade.getContract();
        this.price = trade.getPrice();
        this.quantity = trade.getQuantity();
        this.timeStamp = trade.getTimeStamp();
        this.tradeType = trade.getTradeType();
        this.contractPhase = trade.getContractPhase();
        this.recallRequestedTime = new SimpleObjectProperty<DateTime>((DateTime)trade.getRecallRequestedTime().get());
        this.recallGrantedTime = new SimpleObjectProperty<DateTime>((DateTime)trade.getRecallGrantedTime().get());
        this.recallLatestProcessTime = new SimpleObjectProperty<DateTime>((DateTime)trade.getRecallLatestProcessTime().get());
        this.tradeSettlement = new SimpleObjectProperty<TradeSettlement>((TradeSettlement)trade.getTradeSettlement().get());
        this.decomposed = trade.isDecomposed();
        this.parentTradeId = trade.getParentTradeId();
        this.remoteTradeId = trade.getRemoteTradeId();
        this.selfTrade = trade.selfTrade;
        this.recallRequestor = trade.recallRequestor;
        this.location = trade.location;
    }

    public ObjectProperty<String> getRecallRequestor() {
        return this.recallRequestor;
    }

    public void setRecallRequestor(String recallRequestor) {
        this.recallRequestor.set(recallRequestor);
    }

    public ObjectProperty<String> recallRequestorProperty() {
        return this.recallRequestor;
    }

    public LongDisplayValue getPrice() {
        return this.price;
    }

    public void setPrice(LongDisplayValue price) {
        this.price = price;
    }

    public LongDisplayValue getQuantity() {
        return this.quantity;
    }

    public void setQuantity(LongDisplayValue quantity) {
        this.quantity = quantity;
    }

    public ObjectProperty<DateTime> getRecallGrantedTime() {
        return this.recallGrantedTime;
    }

    public void setRecallGrantedTime(DateTime recallGrantedTime) {
        this.recallGrantedTime.set(recallGrantedTime);
    }

    public ObjectProperty<DateTime> getRecallRequestedTime() {
        return this.recallRequestedTime;
    }

    public void setRecallRequestedTime(DateTime recallRequestedTime) {
        this.recallRequestedTime.set(recallRequestedTime);
    }

    public ObjectProperty<DateTime> getRecallLatestProcessTime() {
        return this.recallLatestProcessTime;
    }

    public void setRecallLatestProcessTime(DateTime recallLatestProcessTime) {
        this.recallLatestProcessTime.set(recallLatestProcessTime);
    }

    public long getRevisionNumber() {
        return this.revisionNumber;
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber = revisionNumber;
    }

    public DateTime getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(DateTime timeStamp) {
        this.timeStamp = timeStamp;
    }

    public ObjectProperty<TradeState> getTradeState() {
        return this.tradeState;
    }

    public void setTradeState(TradeState tradeState) {
        this.tradeState.set(tradeState);
    }

    public TradeType getTradeType() {
        return this.tradeType;
    }

    public void setTradeType(TradeType tradeType) {
        this.tradeType = tradeType;
    }

    public ContractPhase getContractPhase() {
        return this.contractPhase;
    }

    public void setContractPhase(ContractPhase contractPhase) {
        this.contractPhase = contractPhase;
    }

    public Contract getContract() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract = contract;
    }

    public ObjectProperty<TradeSettlement> getTradeSettlement() {
        return this.tradeSettlement;
    }

    public void setTradeSettlement(TradeSettlement tradeSettlement) {
        this.tradeSettlement.set(tradeSettlement);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void updateTradeSettlement(TradeSettlement tradeSettlement) {
        TradeSettlement oldSettlement = (TradeSettlement)this.getTradeSettlement().get();
        if (oldSettlement == null || tradeSettlement.getTradeRevisionNumber() > oldSettlement.getTradeRevisionNumber() || tradeSettlement.getTradeRevisionNumber() == oldSettlement.getTradeRevisionNumber() && tradeSettlement.getStlmntRevisionNumber() > oldSettlement.getStlmntRevisionNumber()) {
            this.setTradeSettlement(tradeSettlement);
        }
    }

    public boolean isDecomposed() {
        return this.decomposed;
    }

    public void setDecomposed(boolean decomposed) {
        this.decomposed = decomposed;
    }

    public Long getParentTradeId() {
        return this.parentTradeId;
    }

    public void setParentTradeId(Long parentTradeId) {
        this.parentTradeId = parentTradeId;
    }

    public Long getRemoteTradeId() {
        return this.remoteTradeId;
    }

    public void setRemoteTradeId(Long remoteTradeId) {
        this.remoteTradeId = remoteTradeId;
    }

    public boolean isSelfTrade() {
        return this.selfTrade;
    }

    public void setSelfTrade(boolean selfTrade) {
        this.selfTrade = selfTrade;
    }

    public String toString() {
        return "Trade{contract=" + String.valueOf(this.getContract()) + ", price=" + String.valueOf(this.getPrice()) + ", quantity=" + String.valueOf(this.getQuantity()) + ", tradeSettlement=" + String.valueOf(this.getTradeSettlement()) + "}";
    }
}

