/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.AbstractComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntrySource;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import java.util.Collections;
import java.util.Comparator;

public class OutrightExtendedOrderbookEntries
extends AbstractComputedOrderbookEntries<ExtendedOrderbookEntry>
implements ExtendedOrderbookEntries {
    public OutrightExtendedOrderbookEntries(Orderbook orderbook, Direction direction) {
        super(orderbook, direction);
        this.populateEntries();
    }

    @Override
    protected void loadBestEntryValue() {
        this.bestEntry.setPrice(((ExtendedOrderbookEntry)this.entries.get(0)).getPrice());
        this.bestEntry.setQuantity(((ExtendedOrderbookEntry)this.entries.get(0)).getQuantity());
        this.bestEntry.setSource(OrderbookEntrySource.OUTRIGHT);
    }

    private void populateEntries() {
        this.entries.addAll(this.rawEntries.getSortedEntries().stream().map(this::createEntry).toList());
        this.reloadVwapAndAccQty(0);
        this.updateBestEntry();
        this.reloadTradability();
    }

    @Override
    protected void rawEntriesBatchUpdateFinished(int minIndexChanged) {
        super.rawEntriesBatchUpdateFinished(minIndexChanged);
        int indexBeforeMinIndexChanged = Math.max(minIndexChanged - 1, 0);
        if (this.size() > 0) {
            boolean accumulatedTradable = minIndexChanged < this.size() && this.size() > 0 && indexBeforeMinIndexChanged == 0 ? ((ExtendedOrderbookEntry)this.entries.get(indexBeforeMinIndexChanged)).getTradable() : ((ExtendedOrderbookEntry)this.entries.get(indexBeforeMinIndexChanged)).isAccumulatedTradable();
            for (int i = indexBeforeMinIndexChanged; i < this.size(); ++i) {
                ((ExtendedOrderbookEntry)this.entries.get(i)).setAccumulatedTradable(accumulatedTradable &= ((ExtendedOrderbookEntry)this.entries.get(i)).getTradable());
            }
        }
    }

    @Override
    protected int rawEntryRemoved(OrderbookEntry rawEntry) {
        return this.find(rawEntry);
    }

    @Override
    protected int rawEntryAdded(OrderbookEntry rawEntry) {
        ExtendedOrderbookEntry newEntry = this.createEntry(rawEntry);
        int index = Collections.binarySearch(this.entries, newEntry, ExtendedOrderbookEntry.getDefaultComparator(this.getDirection()));
        if (index < 0) {
            index = -index - 1;
        }
        this.entries.add(index, newEntry);
        boolean isEntryBeforeAccumulatedTradable = index - 1 < 0 || ((ExtendedOrderbookEntry)this.entries.get(index - 1)).isAccumulatedTradable();
        newEntry.setAccumulatedTradable(isEntryBeforeAccumulatedTradable && newEntry.getTradable());
        return index;
    }

    private ExtendedOrderbookEntry createEntry(OrderbookEntry rawEntry) {
        boolean ownOrder = this.orderbookEntryLookup.isOwnOrder(rawEntry.getOrderId());
        boolean ownUserOrder = this.orderbookEntryLookup.isOwnUserOrder(rawEntry.getOrderId());
        return new ExtendedOrderbookEntry(rawEntry, rawEntry.getLocalTimestamp(), this.orderbook, this.getDirection(), ownOrder, ownUserOrder, true);
    }

    private int find(OrderbookEntry rawEntry) {
        Comparator<ExtendedOrderbookEntry> comparator;
        ExtendedOrderbookEntry searchKey = ExtendedOrderbookEntry.createBinarySearchKey(rawEntry, this.orderbook, this.getDirection());
        int firstEntryWithSamePrice = Collections.binarySearch(this.entries, searchKey, comparator = ExtendedOrderbookEntry.getDefaultComparator(this.getDirection()));
        if (firstEntryWithSamePrice < 0) {
            firstEntryWithSamePrice = -firstEntryWithSamePrice - 1;
        }
        for (int i = firstEntryWithSamePrice; i < this.entries.size() && ((ExtendedOrderbookEntry)this.entries.get(i)).getPrice().equals(rawEntry.getPrice()); ++i) {
            if (!((ExtendedOrderbookEntry)this.entries.get(i)).getOrderId().equals(rawEntry.getOrderId())) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void reloadTradability() {
        boolean accumulatedTradable = true;
        for (ExtendedOrderbookEntry entry : this.entries) {
            boolean entryTradable = entry.isTradable();
            entry.setTradable(entryTradable);
            entry.setAccumulatedTradable(accumulatedTradable &= entryTradable);
        }
    }

    @Override
    protected void reloadOwnQuantities() {
        for (ExtendedOrderbookEntry entry : this.entries) {
            entry.setContainsOwnOrder(this.orderbookEntryLookup.isOwnOrder(entry.getOrderId()));
            entry.setContainsOwnUserOrder(this.orderbookEntryLookup.isOwnUserOrder(entry.getOrderId()));
            entry.invalidateOwnObservable();
        }
    }
}

