/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.type;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public enum JodaDateFormatType implements DisplayName
{
    FORMAT_WITH_MINUS_YYYY_MM_DD("yyyy-MM-dd HH:mm:ss'T'", "HH:mm'T' yyyy-MM-dd", "yyyy-MM-dd", "HH:mm'T'"),
    FORMAT_WITH_DOT_DD_MM_YYYY("dd.MM.yyyy HH:mm:ss'T'", "HH:mm'T' dd.MM.yyyy", "dd.MM.yyyy", "HH:mm'T'"),
    FORMAT_WITH_SLASH_MM_DD_YYYY("MM/dd/yyyy HH:mm:ss'T'", "HH:mm'T' MM/dd/yyyy", "MM/dd/yyyy", "HH:mm'T'"),
    FORMAT_WITH_TIMEZONE_DD_MM_YYYY("dd.MM.yyyy HH:mm:ss'T' ZZZ", "HH:mm'T' dd.MM.yyyy ZZZ", "dd.MM.yyyy ZZZ", "HH:mm'T' ZZZ");

    static final String DST_PLACEHOLDER = "T";
    static final String DST_A = "A";
    static final String DST_B = "B";
    private final String simpleDateFormatPattern;
    private final String timeInFrontDateFormatPattern;
    private final String justDateDateFormatPattern;
    private final String shortTimeFormatPattern;
    private final DateTimeFormatter simpleDateFormatFormatterDST;
    private final DateTimeFormatter timeInFrontDateFormatFormatterDST;
    private final DateTimeFormatter justDateDateFormatFormatterDST;
    private final DateTimeFormatter shortTimeFormatFormatterDST;
    private final DateTimeFormatter simpleDateFormatFormatter;
    private final DateTimeFormatter timeInFrontDateFormatFormatter;
    private final DateTimeFormatter justDateDateFormatFormatter;
    private final DateTimeFormatter shortTimeFormatFormatter;

    private JodaDateFormatType(String simpleDateFormatPattern, String timeInFrontDateFormatPattern, String justDateDateFormatPattern, String shortTimeFormatPattern) {
        this.simpleDateFormatPattern = simpleDateFormatPattern;
        this.timeInFrontDateFormatPattern = timeInFrontDateFormatPattern;
        this.justDateDateFormatPattern = justDateDateFormatPattern;
        this.shortTimeFormatPattern = shortTimeFormatPattern;
        this.simpleDateFormatFormatterDST = DateTimeFormat.forPattern(simpleDateFormatPattern);
        this.timeInFrontDateFormatFormatterDST = DateTimeFormat.forPattern(timeInFrontDateFormatPattern);
        this.justDateDateFormatFormatterDST = DateTimeFormat.forPattern(justDateDateFormatPattern);
        this.shortTimeFormatFormatterDST = DateTimeFormat.forPattern(shortTimeFormatPattern);
        this.simpleDateFormatFormatter = DateTimeFormat.forPattern(simpleDateFormatPattern.replace("'T'", ""));
        this.timeInFrontDateFormatFormatter = DateTimeFormat.forPattern(timeInFrontDateFormatPattern.replace("'T'", ""));
        this.justDateDateFormatFormatter = DateTimeFormat.forPattern(justDateDateFormatPattern.replace("'T'", ""));
        this.shortTimeFormatFormatter = DateTimeFormat.forPattern(shortTimeFormatPattern.replace("'T'", ""));
    }

    public String getSimpleDateFormatPattern() {
        return this.simpleDateFormatPattern;
    }

    public String getTimeInFrontDateFormatPattern() {
        return this.timeInFrontDateFormatPattern;
    }

    public String getJustDateDateFormatPattern() {
        return this.justDateDateFormatPattern;
    }

    public String getShortTimeFormatPattern() {
        return this.shortTimeFormatPattern;
    }

    public String printSimpleDateFormat(DateTime entity) {
        return this.print(this.simpleDateFormatFormatterDST, this.simpleDateFormatFormatter, entity);
    }

    public DateTime parseSimpleDateFormat(String currentText, DateTimeZone zone) {
        return this.parse(this.simpleDateFormatFormatterDST, this.simpleDateFormatFormatter, currentText, zone);
    }

    public String printSimpleDateFormat(LocalDateTime entity) {
        return this.simpleDateFormatFormatter.print(entity);
    }

    public LocalDateTime parseSimpleDateFormat(String currentText) {
        try {
            return this.simpleDateFormatFormatter.parseLocalDateTime(currentText);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public String printTimeInFrontDateFormat(DateTime entity) {
        return this.print(this.timeInFrontDateFormatFormatterDST, this.timeInFrontDateFormatFormatter, entity);
    }

    public DateTime parseTimeInFrontDateFormat(String currentText, DateTimeZone zone) {
        return this.parse(this.timeInFrontDateFormatFormatterDST, this.timeInFrontDateFormatFormatter, currentText, zone);
    }

    public String printJustDateDateFormat(DateTime entity) {
        return this.print(this.justDateDateFormatFormatterDST, this.justDateDateFormatFormatter, entity);
    }

    public DateTime parseJustDateDateFormat(String currentText, DateTimeZone zone) {
        return this.parse(this.justDateDateFormatFormatterDST, this.justDateDateFormatFormatter, currentText, zone);
    }

    public String printShortTimeFormat(DateTime entity) {
        return this.print(this.shortTimeFormatFormatterDST, this.shortTimeFormatFormatter, entity);
    }

    public String printSimpleDateFormatWithTimezone(DateTime entity, DateTimeZone zone) {
        return this.print(this.simpleDateFormatFormatterDST, this.simpleDateFormatFormatter, entity.withZone(zone));
    }

    public String printTimeInFrontDateFormatWithTimezone(DateTime entity, DateTimeZone zone) {
        return this.print(this.timeInFrontDateFormatFormatterDST, this.timeInFrontDateFormatFormatter, entity.withZone(zone));
    }

    public String printJustDateDateFormatWithTimezone(DateTime entity, DateTimeZone zone) {
        return this.print(this.justDateDateFormatFormatterDST, this.justDateDateFormatFormatter, entity.withZone(zone));
    }

    public String printShortTimeFormatWithTimezone(DateTime entity, DateTimeZone zone) {
        return this.print(this.shortTimeFormatFormatterDST, this.shortTimeFormatFormatter, entity.withZone(zone));
    }

    public String print(DateTimeFormatter formatterDST, DateTimeFormatter formatter, DateTime entity) {
        if (this.isInBetweenDSTChange(entity)) {
            return formatterDST.print(entity).replace(DST_PLACEHOLDER, entity.equals(entity.withLaterOffsetAtOverlap()) ? DST_B : DST_A);
        }
        return formatter.print(entity);
    }

    private DateTime parse(DateTimeFormatter formatterDST, DateTimeFormatter formatter, String currentText, DateTimeZone zone) {
        try {
            if (currentText.contains(DST_A)) {
                DateTime dateTime = formatterDST.withZone(zone).parseDateTime(currentText.replaceFirst(DST_A, DST_PLACEHOLDER));
                return dateTime != null ? this.checkInBetweenDST(dateTime.withEarlierOffsetAtOverlap()) : null;
            }
            if (currentText.contains(DST_B)) {
                DateTime dateTime = formatterDST.withZone(zone).parseDateTime(currentText.replaceFirst(DST_B, DST_PLACEHOLDER));
                return dateTime != null ? this.checkInBetweenDST(dateTime.withLaterOffsetAtOverlap()) : null;
            }
            DateTime dateTime = formatter.withZone(zone).parseDateTime(currentText);
            return dateTime != null ? this.checkNotInBetweenDST(dateTime) : null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private boolean isInBetweenDSTChange(DateTime dateTime) {
        return !dateTime.withEarlierOffsetAtOverlap().equals(dateTime.withLaterOffsetAtOverlap());
    }

    private DateTime checkNotInBetweenDST(DateTime dateTime) {
        return !this.isInBetweenDSTChange(dateTime) ? dateTime : null;
    }

    private DateTime checkInBetweenDST(DateTime dateTime) {
        return this.isInBetweenDSTChange(dateTime) ? dateTime : null;
    }

    @Override
    public String getDisplayName() {
        return this.simpleDateFormatPattern;
    }
}

