/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.DateFilterChoice;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ExportableAbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DecomposedTradesChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.DateFilterBottomToolbarComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.TradePanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableTableView;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;

public abstract class AbstractTradePanel<T extends Trade>
extends ExportableAbstractPanel<T>
implements StorableComponent<TradePanelState<T>> {
    @FXML
    protected BottomToolbar bottomToolbar;
    @FXML
    protected CustomTableView<T> tradeTableView;
    @FXML
    protected DateFilterBottomToolbarComponent<T> dateFilterComponent;
    @FXML
    protected DecomposedTradesChoiceBox showDecomposedTrades;
    @FXML
    protected TitledPane menu;

    public AbstractTradePanel(ApplicationContext appContext) {
        super(appContext);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.tradeTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    public void restoreComponentState(TradePanelState<T> componentState) {
        componentState.getTradeTableDescriptor().applyToTable(this.tradeTableView);
        this.menu.setExpanded(componentState.isMenuExpanded());
        this.bottomToolbar.applyToolbarItemState(componentState.getBottomToolbarStoredState());
        this.dateFilterComponent.getDateTypeChoiceBox().setValue(componentState.getDateTypeFilterChoice());
        for (DateFilterChoice dateFilterChoice : this.dateFilterComponent.getDateChoiceBox().getListedItems()) {
            if (dateFilterChoice.getOffsetInDays() != componentState.getDateFilterOffset()) continue;
            this.dateFilterComponent.getDateChoiceBox().setValue(dateFilterChoice);
        }
        this.showDecomposedTrades.restoreSavedState(componentState.isShowDecomposedTrades());
    }

    @Override
    public TableView<T> getTableView() {
        return this.tradeTableView;
    }

    public BottomToolbar getBottomToolbar() {
        return this.bottomToolbar;
    }

    @Override
    protected ExportableTableView<T> getAllExportableTableView() {
        return new ExportableTableView<T>(this.getTableView(), ExportableTableView.Mode.ALL);
    }

    @Override
    protected ExportableTableView<T> getSelectedExportableTableView() {
        return new ExportableTableView<T>(this.getTableView(), ExportableTableView.Mode.SELECTED);
    }

    protected ObservableList<T> getSelectedItems() {
        return this.tradeTableView.getSelectionModel().getSelectedItems();
    }
}

