/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DropTargetParent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.SplitPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.TabPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.ContentTabContextMenu;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.TargetPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.ContentTabClosedEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.ContentTabClosingEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.PreUserDataResetEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.SaveConfigurationEvent;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTab
extends Tab
implements DropTargetParent {
    private static final Logger LOG = LoggerFactory.getLogger(ContentTab.class);
    private final ApplicationContext appContext;
    private final EventBus eventBus;
    private final Map<String, StorableComponent> storableComponents = new HashMap<String, StorableComponent>();
    private final ProfileManager profileManager;
    private volatile AtomicBoolean unregistered = new AtomicBoolean(false);

    public ContentTab(ApplicationContext appContext) {
        this.appContext = appContext;
        this.profileManager = appContext.getService(ProfileManager.class);
        this.eventBus = appContext.getService(EventBus.class);
        this.contentProperty().addListener(this::contentChanged);
        this.setContextMenu(new ContentTabContextMenu(this));
        this.setOnCloseRequest(event -> this.close());
        this.setContent(new PanelWrapper(appContext, new TargetPanel(appContext)));
        this.eventBus.register(this);
    }

    private void contentChanged(ObservableValue<? extends Node> observableValue, Node oldValue, Node newValue) {
        if (oldValue instanceof PanelWrapper && newValue instanceof SplitPanel && !((SplitPanel)newValue).getItems().contains(oldValue)) {
            ((PanelWrapper)oldValue).setDropTargetParent(null);
        }
        if (newValue instanceof PanelWrapper) {
            ((PanelWrapper)newValue).setDropTargetParent(this);
        }
        if (oldValue instanceof Destroyable) {
            ((Destroyable)((Object)oldValue)).destroy();
        }
    }

    private TabPanel getParentTabPanel() {
        return (TabPanel)this.getTabPane();
    }

    public void registerNewStorableComponent(StorableComponent component) {
        this.storableComponents.put(component.getPersistentId(), component);
    }

    public void unregisterStorableComponent(StorableComponent component) {
        this.storableComponents.remove(component.getPersistentId());
    }

    public void restoreComponents() {
        for (Map.Entry<String, StorableComponent> componentEntry : this.storableComponents.entrySet()) {
            String key = componentEntry.getKey();
            StorableComponent component = componentEntry.getValue();
            try {
                Object storedGeneralData = this.profileManager.getCurrentProfile().getComponentData(key);
                if (storedGeneralData == null) continue;
                component.restoreComponentState(storedGeneralData);
            }
            catch (RuntimeException e) {
                LOG.error("Could not restore general component state for {}, {} {}", component.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            }
        }
    }

    @Subscribe
    public void handleLoadingFinished(LoadingFinishedEvent event) {
        this.restoreComponents();
    }

    @Subscribe
    public void handlePreUserDataReset(PreUserDataResetEvent event) {
        this.storeGeneralContent();
    }

    private void storeGeneralContent() {
        for (Map.Entry<String, StorableComponent> componentEntry : this.storableComponents.entrySet()) {
            LOG.info("Storing component: {}", (Object)componentEntry.getValue().getClass().getName());
            Object generalContent = componentEntry.getValue().getComponentState();
            this.profileManager.getCurrentProfile().setComponentData(componentEntry.getKey(), generalContent);
        }
    }

    @Subscribe
    public void handleSaveConfiguration(SaveConfigurationEvent saveConfigurationEvent) {
        this.storeGeneralContent();
    }

    public void editName() {
        TextField textField = new TextField(this.getText());
        this.setText(null);
        this.setGraphic(textField);
        textField.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.ENTER)) {
                this.applyNewTitle(textField.getText());
            }
        });
        textField.focusedProperty().addListener((observableValue, wasFocused, isFocused) -> {
            if ((wasFocused == null || !wasFocused.booleanValue()) && isFocused.booleanValue()) {
                textField.selectAll();
            }
            if (isFocused != null && wasFocused != null && wasFocused.booleanValue() && !isFocused.booleanValue()) {
                this.applyNewTitle(textField.getText());
            }
        });
        textField.requestFocus();
    }

    private void applyNewTitle(String title) {
        this.setGraphic(null);
        this.setText(title);
    }

    public void registerStorableComponents() {
        Node content = this.getContent();
        if (content instanceof SplitPanel) {
            ((SplitPanel)content).registerStorableComponents(this);
        } else if (content instanceof PanelWrapper && ((PanelWrapper)content).isStoreable()) {
            StorableComponent storableComponent = (StorableComponent)((Object)((PanelWrapper)content).getPanel());
            this.registerNewStorableComponent(storableComponent);
        }
    }

    public static Object findParentOfNode(Node node) {
        ContentTab contentTabOfNode = new ContentTabLookup().findContentTabOfNode(node);
        return contentTabOfNode.findParentOfNode(contentTabOfNode, node);
    }

    private Object findParentOfNode(Object currentParent, Node node) {
        if (currentParent instanceof ContentTab) {
            ContentTab tab = (ContentTab)currentParent;
            if (tab.getContent().equals(node)) {
                return tab;
            }
            Object result = this.findParentOfNode(tab.getContent(), node);
            if (result != null) {
                return result;
            }
        } else if (currentParent instanceof SplitPane) {
            for (Node item : ((SplitPane)currentParent).getItems()) {
                if (item.equals(node)) {
                    return currentParent;
                }
                Object result = this.findParentOfNode(item, node);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void unregisterFromAll() {
        boolean alreadyUnregistered = this.unregistered.getAndSet(true);
        if (alreadyUnregistered) {
            LOG.error("The content tab {} has been already unregistered.", (Object)this.getText());
        } else {
            this.eventBus.post(new ContentTabClosingEvent(this));
            this.eventBus.post(new ContentTabClosedEvent(this));
        }
    }

    @Subscribe
    public void handleContentTabClosedEvent(ContentTabClosedEvent event) {
        if (event.getContentTab() == this) {
            this.eventBus.unregister(this);
            this.dispose();
        }
    }

    @Override
    public void removeNode(Node node) {
        this.setContent(new PanelWrapper(this.appContext, new TargetPanel(this.appContext)));
        if (node instanceof DropTargetParent) {
            ((DropTargetParent)((Object)node)).dispose();
        }
    }

    @Override
    public void dispose() {
        Node currentContent = this.getContent();
        if (currentContent instanceof DropTargetParent) {
            ((DropTargetParent)((Object)currentContent)).dispose();
        }
        this.setContent(null);
        this.setContextMenu(null);
    }

    public void close() {
        LOG.info("Closing");
        this.unregisterFromAll();
        this.getParentTabPanel().getTabs().remove(this);
    }

    public void openInNewWindow() {
        this.getParentTabPanel().openContentTabInNewWindow(this);
    }

    public void moveLeft() {
        this.getParentTabPanel().moveTabLeft(this);
    }

    public void moveRight() {
        this.getParentTabPanel().moveTabRight(this);
    }

    public boolean containsNode(Node node) {
        Node currentContent = this.getContent();
        if (currentContent == null) {
            return false;
        }
        for (Node currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            if (currentContent != currentNode) continue;
            return true;
        }
        return false;
    }

    @Singleton
    public static class ContentTabLookup {
        public ContentTab findContentTabOfNode(Node node) {
            return this.findContentTab(null, node);
        }

        private ContentTab findContentTab(Object topmostDropTargetControlerOrSplitPanelSoFar, Node node) {
            Parent parent = node.getParent();
            if (parent == null) {
                return null;
            }
            if (parent instanceof TabPanel) {
                return ((TabPanel)parent).getTabs().stream().filter(ContentTab.class::isInstance).map(ContentTab.class::cast).filter(contentTab -> Objects.equals(contentTab.getContent(), topmostDropTargetControlerOrSplitPanelSoFar)).findFirst().orElse(null);
            }
            if (parent instanceof AbstractPanel || parent instanceof PanelWrapper || parent instanceof SplitPanel) {
                return this.findContentTab(parent, parent);
            }
            if (node instanceof AbstractPanel || node instanceof PanelWrapper || node instanceof SplitPanel) {
                return this.findContentTab(node, parent);
            }
            return this.findContentTab(topmostDropTargetControlerOrSplitPanelSoFar, parent);
        }
    }
}

