/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.query.HubToHubQueries;
import com.deutscheboerse.comxerv.comtrader.entities.AtcId;
import com.deutscheboerse.comxerv.comtrader.entities.H2HArea;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHubState;
import com.deutscheboerse.comxerv.comtrader.entities.type.HubToHubStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryDateFilterChoice;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.HubToHubStatusWidget;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.IntervalDateFilterChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.h2h.HubToHubPanelState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.h2h.HubToHubRow;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CapacityColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableColumnDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.IntervalTree;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.SlideInIntervalTreePane;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TableUpdateManager;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.event.FullHourEvent;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.Subscribe;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DraggableComponent(forUserWithUserRole={"ROLE_CAPACITY_INFO"}, nameKey="hubToHubPanel_title", descriptionKey="hubToHubPanel_description")
@PanelWithLoadingIndicator(entityClasses={HubToHub.class})
public class HubToHubPanel
extends AbstractPanel
implements StorableComponent<HubToHubPanelState> {
    private static final Logger LOG = LoggerFactory.getLogger(HubToHubPanel.class);
    private static final String DLVRY_PRD_COLUMN = "dlvryPrdColumn";
    private static final int UPDATE_INTERVAL = 500;
    private final ScheduledFuture<?> updateTimer;
    @FXML
    private BottomToolbar bottomToolbar;
    @FXML
    private CustomTableView<HubToHubRow> h2hTableView;
    @FXML
    protected IntervalDateFilterChoiceBox intervalDateFilterChoiceBox;
    @FXML
    private HubToHubStatusWidget hubToHubStatusWidget;
    private final SlideInIntervalTreePane slideInIntervalTreePane;
    private final SmallFastDataModel<String, H2HArea> h2HAreaDataModel;
    private final SmallFastDataModel<Integer, HubToHubState> hubToHubStateDataModel;
    private final SmallFastDataModel<AtcId, HubToHub> hubToHubDataModel;
    private final HubToHubQueries hubToHubQueries;
    private final TableUpdateManager tableUpdateManager;
    private final DataModelListener<HubToHub> hubToHubDataModelListener;
    protected final ObservableList<HubToHubRow> allRows;
    protected final FilteredList<HubToHubRow> filteredRows;
    private final ScheduledExecutorService executorService;

    public HubToHubPanel(ApplicationContext appContext) {
        super(appContext);
        this.hubToHubQueries = appContext.getService(HubToHubQueries.class);
        this.h2HAreaDataModel = appContext.getSmallDataModel(H2HArea.class);
        this.hubToHubDataModel = appContext.getSmallDataModel(HubToHub.class);
        this.hubToHubStateDataModel = appContext.getSmallDataModel(HubToHubState.class);
        this.allRows = FXCollections.observableArrayList();
        this.filteredRows = new FilteredList<HubToHubRow>(this.allRows);
        this.tableUpdateManager = appContext.getService(TableUpdateManager.class);
        this.executorService = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.updateTimer = this.executorService.scheduleAtFixedRate(FxUtil.wrapWithRunInFxThread(this::updateHubToHubStatus), 0L, 500L, TimeUnit.MILLISECONDS);
        this.hubToHubDataModelListener = new AbstractDataModelListener<HubToHub>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(HubToHub object) {
                Interval hub2hubInterval = object.getDeliveryPeriod();
                if (HubToHubPanel.this.shouldBeDisplayed(hub2hubInterval) && HubToHubPanel.this.slideInIntervalTreePane.getIntervalTree().isIntervalSelected(hub2hubInterval)) {
                    LOG.debug("Adding {}", (Object)hub2hubInterval);
                    FxUtil.runLater(() -> HubToHubPanel.this.allRows.stream().filter(row -> hub2hubInterval.equals(row.getInterval())).forEach(row -> row.getCapacities().add(object)));
                }
                return super.notifyAdd(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(HubToHub object) {
                LOG.debug("HubToHub removed {}", (Object)object.getDeliveryPeriod());
                return super.notifyRemove(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                FxUtil.runLater(() -> {
                    HubToHubPanel.this.allRows.clear();
                    HubToHubPanel.this.slideInIntervalTreePane.getIntervalTree().setRootSelected(false);
                });
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        this.slideInIntervalTreePane = new SlideInIntervalTreePane(appContext, this::intervalSubscribed);
        this.loadFxml();
    }

    public void intervalSubscribed(Interval interval, boolean subscribed) {
        FxUtil.runLater(() -> {
            if (subscribed) {
                this.allRows.add(new HubToHubRow(interval, this.hubToHubQueries.getForInterval(interval)));
            } else {
                this.allRows.removeIf(row -> row.getInterval().equals(interval));
            }
            this.refilterRows();
        });
    }

    public HubToHubPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getAppContext().getSmallDataModel(HubToHub.class).registerListener(new WeakDataModelListener<HubToHub>(this.hubToHubDataModelListener));
        this.intervalDateFilterChoiceBox.valueProperty().addListener(observable2 -> this.refilterRows());
        this.filteredRows.addListener(change -> this.tableUpdateManager.submitSortRequest(this.h2hTableView));
        SortedList<HubToHubRow> sortedRows = new SortedList<HubToHubRow>((ObservableList<HubToHubRow>)this.filteredRows);
        this.h2hTableView.setItems(sortedRows);
        sortedRows.comparatorProperty().bind(this.h2hTableView.comparatorProperty());
        this.restoreAllColumns(null);
        this.setLeft(this.slideInIntervalTreePane);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.updateTimer.cancel(false);
    }

    private boolean shouldBeDisplayed(HubToHubRow row) {
        return this.shouldBeDisplayed(row.getInterval());
    }

    private boolean shouldBeDisplayed(Interval interval) {
        DeliveryDateFilterChoice deliveryDateFilter = (DeliveryDateFilterChoice)this.intervalDateFilterChoiceBox.getValue();
        DateTime serverTime = this.getAppContext().getService(TimeService.class).getServerTime();
        DateTime displayStartTime = deliveryDateFilter.getStartTime(serverTime);
        DateTime displayEndTime = deliveryDateFilter.getEndTime(serverTime);
        return !interval.getStart().isAfter(displayEndTime) && !interval.getStart().isBefore(displayStartTime);
    }

    protected void refilterRows() {
        this.filteredRows.setPredicate(this::shouldBeDisplayed);
    }

    @Override
    public HubToHubPanelState getComponentState() {
        IntervalTree intervalTree = this.slideInIntervalTreePane.getIntervalTree();
        List<String> intervals = Collections.emptyList();
        if (!intervalTree.isRootSelected()) {
            intervals = intervalTree.getSubscribedIntervals();
        }
        return new HubToHubPanelState(intervalTree.isRootSelected(), intervals, (DeliveryDateFilterChoice)this.intervalDateFilterChoiceBox.getValue(), StorableTableLayoutDescriptor.fromTable(this.h2hTableView, true), this.bottomToolbar.getState());
    }

    @Override
    public void restoreComponentState(HubToHubPanelState componentState) {
        this.restoreAllColumns(componentState);
        IntervalTree intervalTree = this.slideInIntervalTreePane.getIntervalTree();
        this.intervalDateFilterChoiceBox.setValue(componentState.getDeliveryDateFilterChoice());
        this.bottomToolbar.applyToolbarItemState(componentState.getBottomToolbarStoredState());
        intervalTree.setRootSelected(componentState.isRootSubscribed());
        if (!componentState.isRootSubscribed() && componentState.getSubscribedIntervals() != null) {
            for (String strInterval : componentState.getSubscribedIntervals()) {
                intervalTree.setIntervalSelected(strInterval);
            }
        }
    }

    private void restoreAllColumns(HubToHubPanelState componentState) {
        this.h2hTableView.getColumns().removeIf(column -> !DLVRY_PRD_COLUMN.equals(column.getId()));
        List<CapacityColumn<HubToHubRow>> allHubToHubColumns = this.generateHubToHubColumns();
        if (componentState != null) {
            for (Map.Entry<String, StorableTableColumnDescriptor> entry : componentState.getHubToHubTableDescriptor().getColumnDescriptors().entrySet()) {
                if (DLVRY_PRD_COLUMN.equals(entry.getKey())) {
                    this.h2hTableView.getColumns().stream().filter(col -> ((String)entry.getKey()).equals(col.getId())).findFirst().ifPresent(column -> ((StorableTableColumnDescriptor)entry.getValue()).applyToTableColumn((TableColumn<?, ?>)column));
                    continue;
                }
                allHubToHubColumns.stream().filter(col -> ((String)entry.getKey()).equals(col.getId())).findFirst().ifPresent(capacityColumn -> {
                    ((StorableTableColumnDescriptor)entry.getValue()).applyToTableColumn((TableColumn<?, ?>)capacityColumn);
                    this.h2hTableView.getColumns().add(capacityColumn);
                    allHubToHubColumns.remove(capacityColumn);
                });
            }
        }
        this.h2hTableView.getColumns().addAll(allHubToHubColumns);
    }

    private List<CapacityColumn<HubToHubRow>> generateHubToHubColumns() {
        LinkedHashMap columns = new LinkedHashMap();
        List<H2HArea> h2HAreas = this.h2HAreaDataModel.getAllEntitiesAsStream().distinct().sorted(Comparator.comparing(H2HArea::getDisplayName)).toList();
        for (H2HArea from : h2HAreas) {
            for (H2HArea to : h2HAreas) {
                String direction = from.getDisplayName() + "->" + to.getDisplayName();
                if (from.equals(to) || columns.containsKey(direction)) continue;
                columns.put((CallSite)((Object)direction), new CapacityColumn(this.getAppContext(), from, to));
                columns.put((CallSite)((Object)(to.getDisplayName() + "->" + from.getDisplayName())), new CapacityColumn(this.getAppContext(), to, from));
            }
        }
        return new ArrayList<CapacityColumn<HubToHubRow>>(columns.values());
    }

    @Subscribe
    public void handleMidnightEvent(FullHourEvent event) {
        if (event.getHour() == 0) {
            this.refilterRows();
        }
    }

    private void updateHubToHubStatus() {
        HubToHubStatus hubToHubStatus = Optional.ofNullable((HubToHubState)this.hubToHubStateDataModel.findById(0)).map(HubToHubState::getStatus).orElse(null);
        if (this.statusChangedFromConnected(hubToHubStatus)) {
            this.hubToHubDataModel.removeAll();
        }
        this.hubToHubStatusWidget.setValue(hubToHubStatus);
    }

    private boolean statusChangedFromConnected(HubToHubStatus newStatus) {
        HubToHubStatus oldStatus = (HubToHubStatus)((Object)this.hubToHubStatusWidget.getValue());
        return oldStatus != null && !oldStatus.equals((Object)newStatus) && !HubToHubStatus.CONNECTED.equals((Object)newStatus);
    }
}

