/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingStartedEvent;
import com.deutscheboerse.comxerv.comtrader.service.user.MemberService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.ConstantObservableValue;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DraggableComponent(forUserWithUserRole={"ROLE_BROKER", "ROLE_ADMIN"}, nameKey="memberInfoPanel_header_label", descriptionKey="memberInfoPanel_description")
@PanelWithLoadingIndicator(entityClasses={User.class, Product.class, BalancingGroup.class})
public class MemberInfoPanel
extends AbstractPanel {
    private static final Logger LOG = LoggerFactory.getLogger(MemberInfoPanel.class);
    private final SmallFastDataModel<String, Member> memberDataModel;
    @FXML
    private TitledPane title;
    @FXML
    private TabPane exchangeInfoTabPane;
    private final Set<Exchange> loadingInProgress = new HashSet<Exchange>();
    private final Map<Exchange, TreeTableView<List>> exchangeMemberTable = new ConcurrentHashMap<Exchange, TreeTableView<List>>();
    private final ObservableValue<Exchange> activeExchange;
    private final MemberService memberService;
    private final AssignmentService assignmentService;
    private final InvalidationListener invalidationListener;

    public MemberInfoPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected MemberInfoPanel(ApplicationContext appContext) {
        super(appContext);
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.memberService = appContext.getService(MemberService.class);
        this.memberDataModel = appContext.getSmallDataModel(Member.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
        this.loadFxml();
        appContext.getDataModel(User.class).registerHencePostOperationListener(new AbstractDataModelListener<User>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(User object) {
                MemberInfoPanel.this.refresh();
                return super.notifyAdd(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(User object) {
                MemberInfoPanel.this.refresh();
                return super.notifyRemove(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(User object) {
                MemberInfoPanel.this.refresh();
                return super.notifyUpdate(object);
            }
        });
        appContext.getDataModel(BalancingGroup.class).registerHencePostOperationListener(new AbstractDataModelListener<BalancingGroup>(){

            @Override
            public DataModelListener.NotificationResult notifyRemove(BalancingGroup object) {
                MemberInfoPanel.this.refresh();
                return super.notifyRemove(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyAdd(BalancingGroup object) {
                MemberInfoPanel.this.refresh();
                return super.notifyAdd(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(BalancingGroup object) {
                MemberInfoPanel.this.refresh();
                return super.notifyUpdate(object);
            }
        });
        this.invalidationListener = change -> this.refresh();
        this.activeExchange.addListener(new WeakInvalidationListener(this.invalidationListener));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.refresh();
    }

    @Subscribe
    public void handleLoadingFinishedEvent(LoadingFinishedEvent loadingFinishedEvent) {
        this.loadingInProgress.remove(loadingFinishedEvent.getSession().getExchange());
        this.refresh();
    }

    @Subscribe
    public void handleLoadingStartedEvent(LoadingStartedEvent loadingStartedEvent) {
        this.loadingInProgress.add(loadingStartedEvent.getSession().getExchange());
    }

    protected void refresh() {
        if (!this.loadingInProgress.isEmpty()) {
            return;
        }
        LOG.info("MemberInfoPanel refreshing");
        this.exchangeInfoTabPane.getTabs().clear();
        this.exchangeMemberTable.clear();
        Exchange exchange = this.activeExchange.getValue();
        if (exchange != null) {
            TreeTableView<List> memberTable = this.getTableAndTabForExchange(exchange);
            TreeItem<List> root = memberTable.getRoot();
            root.getChildren().clear();
            User ownUser = this.getAppContext().getService(UserService.class).getOwnUser();
            List<Member> members = this.memberDataModel.getAllEntitiesAsStream().filter(this.memberService::isMemberForOnBehalf).sorted().toList();
            for (Member member : members) {
                ArrayList<ObservableValue<String>> memberRowData = new ArrayList<ObservableValue<String>>();
                memberRowData.add(member.displayNameProperty());
                List<User> usersForMember = this.memberService.getUsersForMember(member).sorted((u1, u2) -> u1.getUserCode().compareTo(u2.getUserCode())).toList();
                usersForMember.forEach(user -> memberRowData.add(user.displayNameProperty()));
                for (int columns = memberTable.getColumns().size(); columns < memberRowData.size(); ++columns) {
                    String labelKey = columns == 0 ? "commons_member" : "commons_user";
                    memberTable.getColumns().add(this.createColumn(columns, Util.getLabel(labelKey)));
                }
                if (memberRowData.size() <= 1) continue;
                TreeItem memberItem = new TreeItem(memberRowData);
                memberItem.setExpanded(false);
                root.getChildren().add(memberItem);
                for (Map.Entry<String, Set<String>> entry : this.memberService.getProductsAndBGsForMember((String)member.getId()).entrySet()) {
                    String productId = entry.getKey();
                    ArrayList<Object> productRowData = new ArrayList<Object>();
                    productRowData.add(productId);
                    for (User user2 : usersForMember) {
                        Set<String> availableBgsForUser = user2.getBalancingGroupIds();
                        if (ownUser.getRoles().isBroker()) {
                            availableBgsForUser = Sets.intersection(availableBgsForUser, this.assignmentService.getAssignedBgIdsForBroker(ownUser));
                        } else if (!ownUser.getRoles().isAdmin()) {
                            availableBgsForUser = Sets.intersection(availableBgsForUser, user2.getBalancingGroupIds());
                        }
                        boolean assignable = availableBgsForUser.stream().anyMatch(bgId -> this.assignmentService.isProductAssignedToBg(productId, (String)bgId));
                        productRowData.add(assignable);
                    }
                    memberItem.getChildren().add(new TreeItem(productRowData));
                }
            }
        }
    }

    private TreeTableView<List> getTableAndTabForExchange(Exchange exchange) {
        TreeTableView<List> treeTableView = this.exchangeMemberTable.get(exchange);
        if (treeTableView == null) {
            treeTableView = new TreeTableView();
            treeTableView.setEditable(false);
            treeTableView.setShowRoot(false);
            this.setDeselectionEventHandler(treeTableView);
            TreeItem root = new TreeItem();
            root.setExpanded(true);
            treeTableView.setRoot(root);
            this.exchangeMemberTable.put(exchange, treeTableView);
            Tab exchangeTab = new Tab(exchange.getName());
            exchangeTab.setContent(treeTableView);
            this.exchangeInfoTabPane.getTabs().add(exchangeTab);
        }
        return treeTableView;
    }

    private void setDeselectionEventHandler(TreeTableView<List> treeTableView) {
        treeTableView.setRowFactory(rowFactoryCallback -> {
            TreeTableRow<MouseEvent> row = new TreeTableRow<MouseEvent>();
            row.addEventFilter(MouseEvent.MOUSE_PRESSED, (? super T event) -> {
                int index = row.getIndex();
                if (index >= 0 && treeTableView.getSelectionModel().isSelected(index)) {
                    treeTableView.getSelectionModel().clearSelection();
                    event.consume();
                }
            });
            return row;
        });
    }

    private TreeTableColumn<List, Object> createColumn(final int columnIndex, String title) {
        TreeTableColumn<List, Object> column = new TreeTableColumn<List, Object>(title);
        column.setEditable(false);
        column.setSortable(false);
        column.setCellValueFactory(cellDataFeatures -> {
            TreeItem values2 = cellDataFeatures.getValue();
            if (values2.getValue() == null || columnIndex >= ((List)values2.getValue()).size()) {
                return new ConstantObservableValue<String>("");
            }
            Object value = ((List)cellDataFeatures.getValue().getValue()).get(columnIndex);
            if (value instanceof ObservableValue) {
                return (ObservableValue)value;
            }
            return new ConstantObservableValue(value);
        });
        column.setCellFactory(param -> new TreeTableCell<List, Object>(this){

            @Override
            protected void updateItem(Object item, boolean empty) {
                if (item == this.getItem()) {
                    return;
                }
                super.updateItem(item, empty);
                if (item == null) {
                    this.clearBoth();
                } else if (item instanceof Node) {
                    this.applyGraphic((Node)item);
                } else if (item instanceof Boolean) {
                    if (Boolean.TRUE.equals(item)) {
                        CheckBox checkBox = new CheckBox();
                        checkBox.setSelected(true);
                        checkBox.setDisable(true);
                        checkBox.setOpacity(1.0);
                        this.applyGraphic(checkBox);
                    } else {
                        this.clearBoth();
                    }
                } else {
                    this.applyText(item.toString());
                }
                if (columnIndex > 0) {
                    this.setAlignment(Pos.CENTER);
                }
            }

            private void clearBoth() {
                this.setText(null);
                this.setGraphic(null);
            }

            private void applyText(String text) {
                this.setText(text);
                this.setGraphic(null);
            }

            private void applyGraphic(Node graphic) {
                this.setGraphic(graphic);
                this.setText(null);
            }
        });
        return column;
    }
}

