/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.MemberField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.UserField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.BaseOrderEntryPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.ClearButtonMode;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.fxml.FXML;

@DraggableComponent(forUserWithUserRole={"ROLE_ADMIN", "ROLE_ON_BEHALF", "ROLE_BROKER"}, nameKey="orderEntryPanel_on_behalf_header_label", descriptionKey="orderEntryPanel_on_behalf_description")
public class OnBehalfOrderEntryHorizontalPanel
extends BaseOrderEntryPanel {
    @FXML
    private UserField userField;
    @FXML
    private MemberField memberField;
    private final InvalidationListener onBehalfChanged;
    private final OnBehalfService onBehalfService;

    public OnBehalfOrderEntryHorizontalPanel() {
        this(FXMLLoaderWithContext.getAppContext(), ClearButtonMode.RESET, false);
    }

    public OnBehalfOrderEntryHorizontalPanel(ApplicationContext appContext, ClearButtonMode clearButtonMode, boolean basketMode) {
        super(appContext, clearButtonMode, basketMode, false);
        this.loadFxml();
        this.onBehalfService = this.getAppContext().getService(OnBehalfService.class);
        this.onBehalfChanged = o -> this.handleOnBehalfUserChange(this.onBehalfService.getOnBehalfUser());
        this.onBehalfService.onBehalfUserProperty().addListener(new WeakInvalidationListener(this.onBehalfChanged));
        this.handleOnBehalfUserChange(this.onBehalfService.getOnBehalfUser());
    }

    public void handleOnBehalfUserChange(User onBehalfUser) {
        if (onBehalfUser != null) {
            this.memberField.setText(onBehalfUser.getMember().getDisplayName());
            this.userField.setText(onBehalfUser.getDisplayName());
        } else {
            this.memberField.setText(null);
            this.userField.setText(null);
        }
        this.memberField.setDisable(onBehalfUser != null);
        this.userField.setDisable(onBehalfUser != null);
    }
}

