/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.MemberField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.UserField;
import com.deutscheboerse.comxerv.comtrader.jfx.util.FocusTraversalRestrictionUtils;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;

@DraggableComponent(forUserWithUserRole={"ROLE_ADMIN", "ROLE_ON_BEHALF", "ROLE_BROKER"}, nameKey="onBehalfPanel_title", descriptionKey="onBehalfPanel_description", adminDescriptionKey="onBehalfPanel_description_admin")
public class OnBehalfPanel
extends AbstractPanel {
    @FXML
    private MemberField memberField;
    @FXML
    private UserField userField;
    @FXML
    private Button setButton;
    @FXML
    private Button resetButton;
    private final BooleanProperty onBehalfActive;
    private final OnBehalfService onBehalfService;
    private final ObservableValue<User> selectedOnBehalfUser;
    private final MessagePublisher messagePublisher;
    private final ObservableObjectValue<Exchange> activeExchange;
    private final InvalidationListener activeExchangeChange;
    private final InvalidationListener onBehalfUserChange;
    private static final String ON_BEHALF_ACTIVE_STYLE_CLASS = "onBehalfActive";

    public OnBehalfPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OnBehalfPanel(ApplicationContext appContext) {
        super(appContext);
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.messagePublisher = appContext.getService(MessagePublisher.class);
        this.onBehalfService = appContext.getService(OnBehalfService.class);
        this.selectedOnBehalfUser = this.onBehalfService.onBehalfUserProperty();
        this.onBehalfActive = new SimpleBooleanProperty(false);
        this.activeExchangeChange = observable2 -> this.synchronizeStateWithOnBehalfService();
        this.onBehalfUserChange = change -> this.synchronizeStateWithOnBehalfService();
        this.activeExchange.addListener(new WeakInvalidationListener(this.activeExchangeChange));
        this.selectedOnBehalfUser.addListener(new WeakInvalidationListener(this.onBehalfUserChange));
        this.loadFxml();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.userField.memberProperty().bind(this.memberField.valueProperty());
        this.setButton.disableProperty().bind(this.memberField.valueProperty().isNull().or(this.userField.valueProperty().isNull()).or(this.onBehalfActive));
        this.setButton.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.setButtonAction();
            }
        });
        this.userField.editableProperty().bind(this.onBehalfActive.not());
        this.memberField.editableProperty().bind(this.onBehalfActive.not());
        this.onBehalfActive.addListener((observableValue, oldValue, newValue) -> {
            StyleUtil.addStyleClass(this.memberField, ON_BEHALF_ACTIVE_STYLE_CLASS, newValue);
            StyleUtil.addStyleClass(this.userField, ON_BEHALF_ACTIVE_STYLE_CLASS, newValue);
        });
        this.resetButton.disableProperty().bind(this.onBehalfActive.not());
        this.resetButton.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.resetButtonAction();
            }
        });
        this.synchronizeStateWithOnBehalfService();
        FocusTraversalRestrictionUtils.registerListenersToGuiComponents(this.userField, this.resetButton);
    }

    private void synchronizeStateWithOnBehalfService() {
        User currentOnBehalfUser = this.onBehalfService.getOnBehalfUser();
        if (currentOnBehalfUser != null) {
            this.memberField.setText(currentOnBehalfUser.getMember().getDisplayName());
            this.userField.setText(currentOnBehalfUser.getDisplayName());
            this.onBehalfActive.setValue(true);
        } else {
            this.memberField.setText("");
            this.userField.setText("");
            this.onBehalfActive.setValue(false);
        }
    }

    @FXML
    public void resetButtonAction() {
        this.requestFocus();
        if (this.onBehalfService.setOnBehalfUser(null)) {
            this.memberField.clear();
            this.userField.clear();
            String messageText = Util.getLabel("onBehalfPanel_messageReset");
            this.messagePublisher.publishMessage(messageText, MessageSeverity.MEDIUM);
            this.onBehalfActive.setValue(false);
        }
    }

    @FXML
    public void setButtonAction() {
        this.requestFocus();
        User user = (User)this.userField.getValue();
        Member member = (Member)this.memberField.getValue();
        if (this.onBehalfService.setOnBehalfUser(user)) {
            String messageText = Util.getLabel("onBehalfPanel_messageSet", user.getDisplayName(), member.getDisplayName());
            this.messagePublisher.publishMessage(messageText, MessageSeverity.MEDIUM);
            this.onBehalfActive.setValue(true);
        }
    }
}

