/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelInClipBoard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PanelFactory.class);

    private PanelFactory() {
    }

    public static AbstractPanel createPanel(PanelInClipBoard panelInClipBoard, ApplicationContext applicationContext) {
        AbstractPanel panel = PanelFactory.createPanel(panelInClipBoard.getPanelClass(), applicationContext);
        if (panel instanceof StorableComponent && panelInClipBoard.getPanelState() != null) {
            ((StorableComponent)((Object)panel)).restoreComponentState(panelInClipBoard.getPanelState());
        }
        return panel;
    }

    public static AbstractPanel createPanel(String className, ApplicationContext appContext) {
        try {
            return PanelFactory.createPanel(Class.forName(className), appContext);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not load component class " + className, e);
            return null;
        }
    }

    public static AbstractPanel createPanel(Class<? extends AbstractPanel> clazz, ApplicationContext appContext) {
        return (AbstractPanel)FXMLLoaderWithContext.createComponent(clazz, appContext);
    }
}

