/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.aware.label;

import com.deutscheboerse.comxerv.comtrader.jfx.components.aware.label.LabelKeyAware;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.apache.commons.lang3.StringUtils;

public class LabelKeyAwareButton
extends Button
implements LabelKeyAware {
    StringProperty labelId = new SimpleStringProperty();

    public LabelKeyAwareButton() {
        this.registerFocusRemoverAfterClick();
    }

    public LabelKeyAwareButton(String text) {
        super(text);
        this.registerFocusRemoverAfterClick();
    }

    public LabelKeyAwareButton(String text, Node graphic) {
        super(text, graphic);
        this.registerFocusRemoverAfterClick();
    }

    void registerFocusRemoverAfterClick() {
        this.addEventHandler(ActionEvent.ANY, (? super T event) -> {
            MouseEvent mouseEventExited = new MouseEvent(MouseEvent.MOUSE_EXITED, 0.0, 0.0, 0.0, 0.0, MouseButton.NONE, 0, false, false, false, false, false, false, false, false, false, false, null);
            this.fireEvent(mouseEventExited);
        });
    }

    public String getLabelId() {
        return (String)this.labelId.get();
    }

    public void setLabelId(String labelId) {
        this.labelId.set(labelId);
        this.reloadLabel();
    }

    public StringProperty labelIdProperty() {
        return this.labelId;
    }

    @Override
    public void reloadLabel() {
        if (StringUtils.isNotBlank((CharSequence)this.labelId.get())) {
            this.setText(Util.getLabel((String)this.labelId.get()));
        }
    }
}

