/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke.BalancingGroupField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke.BrokerTraderField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke.MemberField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.bespoke.TraderField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryAreaAssignedToUserChoiceBox;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;

public class TradeSidePane
extends FXMLBorderPane {
    @FXML
    private Label directionLabel;
    @FXML
    private GridPane content;
    @FXML
    private MemberField memberField;
    @FXML
    private TraderField traderField;
    @FXML
    private BrokerTraderField brokerTraderField;
    @FXML
    private BalancingGroupField balancingGroupField;
    @FXML
    private ComboBox<OpenOrClose> openOrCloseField;
    @FXML
    private DeliveryAreaAssignedToUserChoiceBox deliveryAreaChoiceBox;
    private final ObjectProperty<Product> product = new SimpleObjectProperty<Product>();
    private final BooleanProperty isOpenClose = new SimpleBooleanProperty();
    private final ObjectProperty<Direction> direction = new SimpleObjectProperty<Direction>();
    private final BooleanProperty valid = new SimpleBooleanProperty();

    public TradeSidePane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public TradeSidePane(ApplicationContext appContext) {
        super(appContext);
        this.loadFxml();
    }

    public void initialize() {
        this.initMemberField();
        this.initBrokerTrader();
        this.initOpenClose();
        this.initTraderField();
        this.initBGField();
        this.initPrefix();
        this.initDeliveryAreaChoiceBox();
        this.initValidProperty();
    }

    private void initValidProperty() {
        this.valid.bind(this.memberField.validProperty().and(this.traderField.validProperty()).and(this.balancingGroupField.validProperty()).and(this.brokerTraderField.validProperty()).and(this.deliveryAreaChoiceBox.valueProperty().isNotNull()));
    }

    private void initBrokerTrader() {
        this.brokerTraderField.productProperty().bind(this.product);
        this.brokerTraderField.memberProperty().bind(this.memberField.valueProperty());
        this.brokerTraderField.traderProperty().bind(this.traderField.valueProperty());
    }

    private void initMemberField() {
        this.memberField.valueProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                this.brokerTraderField.setText("");
                this.traderField.setText("");
            }
        });
    }

    private void initTraderField() {
        this.traderField.memberProperty().bind(this.memberField.valueProperty());
        this.traderField.valueProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                this.balancingGroupField.setText("");
            }
        });
    }

    private void initBGField() {
        this.balancingGroupField.productProperty().bind(this.product);
        this.balancingGroupField.traderProperty().bind(this.traderField.valueProperty());
    }

    private void initDeliveryAreaChoiceBox() {
        this.deliveryAreaChoiceBox.onBehalfUserProperty().bind(this.traderField.valueProperty());
    }

    private void initPrefix() {
        this.direction.addListener((observable2, oldValue, newValue) -> {
            this.directionLabel.setText(newValue.getDescription());
            this.content.getStyleClass().remove(this.getStyleClass((Direction)oldValue));
            StyleUtil.addStyleClass(this.content, this.getStyleClass((Direction)newValue));
        });
    }

    private String getStyleClass(Direction direction) {
        if (direction == null) {
            return "";
        }
        switch (direction) {
            case BUY: {
                return "buy";
            }
            case SELL: {
                return "sell";
            }
        }
        return "";
    }

    private void initOpenClose() {
        if (this.openOrCloseField.isVisible()) {
            this.openOrCloseField.getItems().addAll((OpenOrClose[])OpenOrClose.values());
            this.openOrCloseField.visibleProperty().bind(this.isOpenClose);
        }
        this.isOpenClose.bind(DependentBinding.get(Product::supportsOpenCloseIndicator, this.product));
    }

    public MemberField getMemberField() {
        return this.memberField;
    }

    public TraderField getTraderField() {
        return this.traderField;
    }

    public DeliveryAreaAssignedToUserChoiceBox getDeliveryAreaChoiceBox() {
        return this.deliveryAreaChoiceBox;
    }

    public BrokerTraderField getBrokerTraderField() {
        return this.brokerTraderField;
    }

    public BalancingGroupField getBalancingGroupField() {
        return this.balancingGroupField;
    }

    public ComboBox<OpenOrClose> getOpenOrCloseField() {
        return this.openOrCloseField;
    }

    public Product getProduct() {
        return (Product)this.product.get();
    }

    public ObjectProperty<Product> productProperty() {
        return this.product;
    }

    public boolean getIsOpenClose() {
        return this.isOpenClose.get();
    }

    public BooleanProperty isOpenCloseProperty() {
        return this.isOpenClose;
    }

    public void resetFields() {
        this.memberField.setText("");
        this.traderField.setText("");
        this.brokerTraderField.setText("");
        this.openOrCloseField.getSelectionModel().clearSelection();
        this.balancingGroupField.setText("");
    }

    public Direction getDirection() {
        return (Direction)this.direction.get();
    }

    public ObjectProperty<Direction> directionProperty() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction.set(direction);
    }

    public boolean getValid() {
        return this.valid.get();
    }

    public BooleanProperty validProperty() {
        return this.valid;
    }
}

