/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;

public abstract class BaseWidget<T extends Enum<T>>
extends Label {
    private final ObjectProperty<T> value = new SimpleObjectProperty();
    private final StringProperty description = new SimpleStringProperty();
    private static final Tooltip SHARED_TOOLTIP = new Tooltip();

    public BaseWidget() {
        StyleUtil.addStyleClass(this, "widget");
        this.setOnMouseEntered(event -> SHARED_TOOLTIP.setText(this.getDescription()));
        this.value.addListener((observable2, oldValue, newValue) -> {
            if (oldValue != null) {
                this.getStyleClass().remove(this.getStyleClass(oldValue));
            }
            if (newValue != null) {
                StyleUtil.addStyleClass(this, this.getStyleClass(newValue));
            }
        });
        this.textProperty().bind(DependentBinding.get(this::getText, this.value));
    }

    private String getStyleClass(T value) {
        return ((Enum)value).getDeclaringClass().getSimpleName() + "_" + ((Enum)value).name();
    }

    protected abstract String getText(T var1);

    public T getValue() {
        return (T)((Enum)this.value.get());
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public void setValue(T value) {
        this.value.set(value);
    }

    public String getDescription() {
        return (String)this.description.get();
    }

    public StringProperty descriptionProperty() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description.set(description);
    }
}

