/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.filter.ContractFilters;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.EntityAutoCompleteField;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentObservableValue;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.StringUtils;

public abstract class ContractField
extends EntityAutoCompleteField<Contract> {
    private final ContractQueries contractQueries;
    private final UserService userService;
    private final AssignmentService assignmentService;
    private final ObjectProperty<Product> product;
    private final ObjectProperty<Mode> mode = new SimpleObjectProperty<Mode>(Mode.ALL);
    private final BooleanProperty allowEmpty = new SimpleBooleanProperty(false);
    private final BooleanProperty assignedOnly = new SimpleBooleanProperty(false);

    public ContractField(ApplicationContext appContext) {
        super(appContext);
        this.product = new SimpleObjectProperty<Product>();
        this.contractQueries = appContext.getService(ContractQueries.class);
        this.userService = appContext.getService(UserService.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
        StyleUtil.addStyleClass(this, "contractField");
        this.focusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (!oldValue.booleanValue() && newValue.booleanValue()) {
                FxUtil.runInFxThread(() -> {
                    if (this.isFocused() && !StringUtils.isEmpty(this.getText())) {
                        this.selectAll();
                    }
                });
            }
            this.setValidationErrorStyleIfNeeded();
        });
        this.valueProperty().addListener((observable2, oldValue, newValue) -> this.setValidationErrorStyleIfNeeded());
        this.setToStringConverter(Contract::getName);
    }

    public abstract boolean filterValue(Contract var1);

    public boolean filterSuggestion(Contract contract) {
        return this.filterValue(contract);
    }

    @Override
    public Stream<Contract> getSuggestedEntities(String currentText) {
        return this.contractQueries.findByNameContainsIgnoreCase(StringUtils.trimToEmpty(currentText)).addFilter(this::isValidOption).addFilter(this::filterSuggestion).getAll().sorted(Contract.DEFAULT_DISPLAY_COMPARATOR);
    }

    @Override
    public Optional<Contract> getEntity(String currentText) {
        if (currentText != null) {
            return this.contractQueries.findByName(currentText).addFilter(this::isValidOption).addFilter(this::filterValue).getFirst();
        }
        return Optional.empty();
    }

    private boolean isValidOption(Contract contract) {
        return this.isFromProduct(contract) && this.isAssigned(contract) && ContractFilters.ACTIVE.test(contract);
    }

    private boolean isFromProduct(Contract contract) {
        switch (this.getMode().ordinal()) {
            case 1: {
                return this.getProduct() == null || contract.getProduct().equals(this.getProduct());
            }
            case 2: {
                return contract.getProduct().equals(this.getProduct());
            }
        }
        return true;
    }

    private boolean isAssigned(Contract contract) {
        if (!this.getAssignedOnly()) {
            return true;
        }
        if (contract != null && contract.getProduct() != null) {
            User user = this.userService.getCurrentUser();
            return this.assignmentService.getProductIds(user).contains(contract.getProduct().getId());
        }
        return false;
    }

    private void setValidationErrorStyleIfNeeded() {
        this.setValid(this.calculateValid());
    }

    public boolean calculateValid() {
        return Optional.ofNullable((Contract)this.getValue()).isPresent() || this.isAllowEmpty();
    }

    public Product getProduct() {
        return (Product)this.product.get();
    }

    public ObjectProperty<Product> productProperty() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product.set(product);
    }

    public Mode getMode() {
        return (Mode)((Object)this.mode.get());
    }

    public ObjectProperty<Mode> modeProperty() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode.set(mode);
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty.get();
    }

    public BooleanProperty allowEmptyProperty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty.set(allowEmpty);
    }

    public boolean getAssignedOnly() {
        return this.assignedOnly.get();
    }

    public BooleanProperty assignedOnlyProperty() {
        return this.assignedOnly;
    }

    public void setAssignedOnly(boolean assignedOnly) {
        this.assignedOnly.set(assignedOnly);
    }

    public void showValidationWarningIfContractIsInactive() {
        DependentObservableValue<Contract, ContractStatus> contractStatus = new DependentObservableValue<Contract, ContractStatus>(this, this.valueProperty(), new Observable[0]){

            @Override
            public ObservableValue<ContractStatus> getObservableValue(Contract contract) {
                return new WeakObservableValue<ContractStatus>(contract.getCompoundStatus().contractStatusProperty());
            }
        };
        contractStatus.addListener((observableValue, oldValue, newValue) -> {
            Contract contract = (Contract)this.getValue();
            if (contract != null) {
                StyleUtil.addStyleClass(this, "validationWarning", !ContractFilters.ACTIVE.test(contract));
            }
        });
    }

    public static enum Mode {
        ALL,
        ALL_OR_PRODUCT_SPECIFIC,
        PRODUCT_SPECIFIC;

    }
}

