/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.EntityAutoCompleteField;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class EntityWithNameAutoCompleteField<T extends BroadcastEntity>
extends EntityAutoCompleteField<T> {
    protected static final Pattern ID_AND_NAME_PATTERN = Pattern.compile("(.*?) \\((.*)\\)");

    public EntityWithNameAutoCompleteField(ApplicationContext appContext) {
        super(appContext);
    }

    protected String getIdFromText(String text) {
        return this.getMatchingPatternGroup(text, 1);
    }

    protected String getNameFromText(String text) {
        return this.getMatchingPatternGroup(text, 2);
    }

    private String getMatchingPatternGroup(String text, int group) {
        Matcher matcher = ID_AND_NAME_PATTERN.matcher(text);
        if (matcher.matches()) {
            return matcher.group(group);
        }
        return text;
    }
}

