/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.EntityFilters;
import com.deutscheboerse.comxerv.comtrader.entities.Member;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.EntityWithNameAutoCompleteField;
import com.deutscheboerse.comxerv.comtrader.service.user.MemberService;
import com.deutscheboerse.ui.jfx.util.control.AutoCompleteTextField;
import java.util.Optional;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.commons.lang3.StringUtils;

public class UserField
extends EntityWithNameAutoCompleteField<User> {
    private final MemberService memberService;
    private final ObjectProperty<Member> member;
    private final BooleanProperty allowEmpty = new SimpleBooleanProperty(false);

    public UserField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public UserField(ApplicationContext appContext) {
        super(appContext);
        this.memberService = appContext.getService(MemberService.class);
        this.member = new SimpleObjectProperty<Member>();
        this.member.addListener((observable2, oldValue, newValue) -> this.memberChanged());
        this.member.addListener(this.recomputeValueListener());
        this.setToStringConverter(User::getDisplayName);
        this.memberChanged();
    }

    private void memberChanged() {
        this.setText("");
    }

    @Override
    public Stream<User> getSuggestedEntities(String currentText) {
        return this.memberService.getUsersForMember(this.getMember()).filter(EntityFilters.containsIgnoreCase(this.getToStringConverter(), StringUtils.trimToEmpty(currentText))).filter(u -> u.getRoles().isTrader() || u.getRoles().isBroker() && u.getRoles().isOwnTrading()).sorted(new AutoCompleteTextField.ToStringConverterComparator(this.getToStringConverter()));
    }

    @Override
    public Optional<User> getEntity(String currentText) {
        Member currentMember = (Member)this.member.get();
        if (StringUtils.isNotEmpty(currentText) && currentMember != null) {
            Optional<User> optional = this.memberService.getUsersForMember(currentMember).filter(EntityFilters.propertyEquals(this.getToStringConverter(), StringUtils.trimToEmpty(currentText))).findFirst();
            this.setValid(optional.isPresent());
            return optional;
        }
        this.setValid(this.allowEmpty.get());
        return Optional.empty();
    }

    public boolean getAllowEmpty() {
        return this.allowEmpty.get();
    }

    public BooleanProperty allowEmptyProperty() {
        return this.allowEmpty;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty.set(allowEmpty);
    }

    public Member getMember() {
        return (Member)this.member.get();
    }

    public ObjectProperty<Member> memberProperty() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member.set(member);
    }
}

