/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import org.joda.time.DateTime;

public enum DateTypeFilterChoice implements DisplayName
{
    TRADING_DATE("commons_tradingDate"){

        @Override
        public boolean isIn(Trade trade, DateTime from, DateTime to) {
            DateTime tradeTime = trade.getTimeStamp();
            return !tradeTime.isBefore(from) && tradeTime.isBefore(to);
        }
    }
    ,
    DELIVERY_DATE("commons_deliveryDate"){

        @Override
        public boolean isIn(Trade trade, DateTime from, DateTime to) {
            return trade.getContract().getDeliveryStart().isBefore(to) && trade.getContract().getDeliveryEnd().isAfter(from);
        }
    };

    private String label;

    private DateTypeFilterChoice(String labelId) {
        this.label = Util.getLabel(labelId);
    }

    @Override
    public String getDisplayName() {
        return this.label;
    }

    public abstract boolean isIn(Trade var1, DateTime var2, DateTime var3);
}

