/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.StorableBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.HBox;

public class MessageSeverityCheckBox
extends HBox
implements StorableBottomToolbarNode<EnumSet<MessageSeverity>> {
    private final Map<MessageSeverity, CheckBox> map;
    private final ObjectProperty<Predicate<Message>> filter = new SimpleObjectProperty<Predicate<Message>>(message -> true);

    public MessageSeverityCheckBox() {
        this.map = new EnumMap<MessageSeverity, CheckBox>(MessageSeverity.class);
        for (MessageSeverity severity : MessageSeverity.values()) {
            CheckBox checkBox = new CheckBox(severity.getDescription());
            checkBox.setSelected(true);
            checkBox.setPrefWidth(-1.0);
            checkBox.setMinWidth(Double.NEGATIVE_INFINITY);
            checkBox.selectedProperty().addListener(observable2 -> this.filter.setValue(message -> this.map.get(message.getSeverity()).isSelected()));
            TooltipUtils.setTooltip(checkBox, this.getDescription());
            this.getChildren().add(checkBox);
            this.map.put(severity, checkBox);
        }
    }

    public ObservableValue<Predicate<Message>> getFilter() {
        return this.filter;
    }

    @Override
    public Node getPreviewForConfigTable() {
        HBox hBox = new HBox();
        hBox.setSpacing(this.getSpacing());
        for (MessageSeverity severity : MessageSeverity.values()) {
            CheckBox checkBox = new CheckBox(severity.getDescription());
            checkBox.setDisable(true);
            checkBox.setPrefWidth(-1.0);
            checkBox.setMinWidth(Double.NEGATIVE_INFINITY);
            hBox.getChildren().add(checkBox);
        }
        return hBox;
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_messagePanel_priority");
    }

    @Override
    public void restoreSavedState(EnumSet<MessageSeverity> state) {
        this.map.entrySet().forEach(entry -> ((CheckBox)entry.getValue()).setSelected(state.contains(entry.getKey())));
    }

    @Override
    public EnumSet<MessageSeverity> getState() {
        return this.map.entrySet().stream().filter(e -> ((CheckBox)e.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toCollection(() -> EnumSet.noneOf(MessageSeverity.class)));
    }
}

