/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.AcceptOrRejectType;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu.LazyOrderContextMenu;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu.OtcContextMenuFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ContextMenuIcon;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OtcOrderService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

public class OtcContextMenuFactoryImpl
implements OtcContextMenuFactory {
    private final ApplicationContext applicationContext;

    @Inject
    public OtcContextMenuFactoryImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public ContextMenu createOtcContextMenu(List<Order> otcOrders) {
        return new OtcContextMenu(this.applicationContext, otcOrders);
    }

    private static class OtcContextMenu
    extends LazyOrderContextMenu {
        private final List<Order> otcOrders;
        private final OtcOrderService otcOrderService;

        public OtcContextMenu(ApplicationContext appContext, List<Order> otcOrders) {
            super(appContext);
            this.otcOrders = otcOrders;
            this.otcOrderService = appContext.getService(OtcOrderService.class, (Exchange)appContext.getService(ActiveExchange.class).getActiveExchange().getValue());
        }

        @Override
        protected List<? extends MenuItem> rebuildItems() {
            if (this.otcOrders.size() == 1) {
                return this.rebuildItems(this.otcOrders.get(0));
            }
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
            if (this.validationService.canBeActivated(this.otcOrders)) {
                menuItems.add(this.activateMenuItem(this.otcOrders));
            } else if (this.validationService.canBeDeactivated(this.otcOrders)) {
                menuItems.add(this.deactivateMenuItem(this.otcOrders));
            }
            if (this.otcOrderService.isOtcOrderCancellable(this.otcOrders)) {
                menuItems.add(this.addCancelItem());
            }
            return menuItems;
        }

        private List<? extends MenuItem> rebuildItems(Order otcOrder) {
            if (OrderStatus.MODI == otcOrder.getStatus() || OrderStatus.SENT == otcOrder.getStatus()) {
                return Collections.emptyList();
            }
            if (OrderStatus.ERROR.equals(otcOrder.getStatus())) {
                return this.getErrorOrderMenuItems(otcOrder);
            }
            return this.getActiveOrHibernamtedOrderMenuItems(otcOrder);
        }

        private List<? extends MenuItem> getErrorOrderMenuItems(Order otcOrder) {
            return Lists.newArrayList(this.resendMenuItem(otcOrder), this.prefillMenuItem(otcOrder), this.removeMenuItem(otcOrder), this.removeAllMenuItem());
        }

        private List<? extends MenuItem> getActiveOrHibernamtedOrderMenuItems(Order otcOrder) {
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
            if (this.otcOrderService.isOtcOrderAcceptable(otcOrder)) {
                menuItems.add(this.addAcceptItem(otcOrder));
            }
            if (this.otcOrderService.isOtcOrderModifiable(otcOrder)) {
                menuItems.add(this.addModifyItem(otcOrder));
                menuItems.add(this.addActivateDeactivateItem(otcOrder));
            }
            if (this.otcOrderService.isOtcOrderRejectable(otcOrder)) {
                menuItems.add(this.addRejectItem(otcOrder));
            }
            if (this.otcOrderService.isOtcOrderCancellable(this.otcOrders)) {
                menuItems.add(this.addCancelItem());
            }
            return menuItems;
        }

        private MenuItem addCancelItem() {
            MenuItem cancel = new MenuItem(Util.getLabel("commons_cancel"));
            cancel.setGraphic(new IconView(ContextMenuIcon.CANCEL.getIconStyleClass()));
            cancel.setOnAction(event -> this.otcOrderService.modifyOtcOrder(this.otcOrders, RequestType.DELETE));
            return cancel;
        }

        private MenuItem addRejectItem(Order otcOrder) {
            MenuItem reject = new MenuItem(Util.getLabel("commons_reject"));
            reject.setGraphic(new IconView(ContextMenuIcon.REJECT.getIconStyleClass()));
            reject.setOnAction(event -> this.otcOrderService.rejectOtcOrder(otcOrder));
            return reject;
        }

        private MenuItem addActivateDeactivateItem(Order otcOrder) {
            if (OrderStatus.ACTIVE == otcOrder.getStatus()) {
                return this.deactivateMenuItem(this.otcOrders);
            }
            if (OrderStatus.HIBERNATE == otcOrder.getStatus()) {
                return this.activateMenuItem(otcOrder);
            }
            return new MenuItem();
        }

        private MenuItem addModifyItem(Order otcOrder) {
            MenuItem modify = new MenuItem(Util.getLabel("commons_modify"));
            modify.setGraphic(new IconView(ContextMenuIcon.MODIFY.getIconStyleClass()));
            modify.setOnAction(event -> {
                otcOrder.setPreArrangedAcceptOrReject(null);
                this.orderPopup.showExtendedOrderPopup(otcOrder, false, modify.getGraphic());
            });
            return modify;
        }

        private MenuItem addAcceptItem(Order otcOrder) {
            MenuItem accept = new MenuItem(Util.getLabel("otcPanel_accept"));
            accept.setGraphic(new IconView(ContextMenuIcon.ACCEPT.getIconStyleClass()));
            accept.setOnAction(event -> {
                otcOrder.setPreArrangedAcceptOrReject(AcceptOrRejectType.ACCEPT);
                this.orderPopup.showAcceptOtcOrderPopup(otcOrder, accept.getGraphic());
            });
            return accept;
        }
    }
}

