/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.customization.column;

import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.column.ColumnColor;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class ColumnColorPicker
extends MenuButton {
    private final ObjectProperty<ColumnColor> value = new SimpleObjectProperty<ColumnColor>(ColumnColor.DEFAULT);

    public ColumnColorPicker() {
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.graphicProperty().bind(DependentBinding.get(this::getPreview, this.valueProperty()));
        Stream.of(ColumnColor.values()).map(this::createMenuItem).forEach(this.getItems()::add);
    }

    private MenuItem createMenuItem(ColumnColor color) {
        MenuItem menuItem = new MenuItem();
        menuItem.setGraphic(this.getPreview(color));
        menuItem.setOnAction(event -> this.setValue(color));
        return menuItem;
    }

    private Node getPreview(ColumnColor color) {
        if (color == ColumnColor.DEFAULT) {
            Text label = new Text(Util.getLabel(color.getLabelKey()));
            label.getStyleClass().add("text");
            return label;
        }
        Rectangle rectangle = new Rectangle(50.0, 10.0, color.getColor());
        rectangle.setStroke(Color.GRAY);
        rectangle.setStrokeWidth(1.0);
        return rectangle;
    }

    public ColumnColor getValue() {
        return (ColumnColor)((Object)this.value.get());
    }

    public ObjectProperty<ColumnColor> valueProperty() {
        return this.value;
    }

    public void setValue(ColumnColor value) {
        this.value.set(value);
    }
}

