/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.common.CustomizableItem;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.common.ToolbarPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarItem;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarItemsTable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.LabeledBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.StorableBottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.components.state.BottomToolbarItemState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.state.BottomToolbarStoredState;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.DefaultProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.HBox;

@DefaultProperty(value="toolbarItems")
public class BottomToolbar
extends HBox
implements Destroyable {
    @FXML
    private HBox content;
    private final ApplicationContext appContext;
    private final BottomToolbarItemsTable toolbarMenuTable;
    private String title = "";

    public BottomToolbar() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public BottomToolbar(ApplicationContext appContext) {
        this.appContext = appContext;
        this.toolbarMenuTable = new BottomToolbarItemsTable(appContext);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        this.parentProperty().addListener(new ChangeListener<Parent>(){

            @Override
            public void changed(ObservableValue<? extends Parent> parentProperty, Parent oldValue, Parent newValue) {
                if (newValue != null) {
                    BottomToolbar.this.content.getChildren().stream().forEach(BottomToolbar.this::initializeItem);
                    parentProperty.removeListener(this);
                    BottomToolbar.this.toolbarMenuTable.getItems().addListener(items -> BottomToolbar.this.reloadChildren());
                }
            }
        });
    }

    private void initializeItem(Node itemNode) {
        if (itemNode instanceof BottomToolbarNode) {
            BottomToolbarNode item = (BottomToolbarNode)((Object)itemNode);
            BottomToolbarItem tableItem = new BottomToolbarItem((Node)((Object)item), item.getPreviewForConfigTable(), item.getDescription(), item.isHidable());
            if (itemNode instanceof LabeledBottomToolbarNode) {
                LabeledBottomToolbarNode labeledItem = (LabeledBottomToolbarNode)((Object)itemNode);
                tableItem.setShowLabel(labeledItem.isShowLabel());
                labeledItem.showLabelProperty().bind(tableItem.showLabelProperty());
            }
            tableItem.visibleProperty().addListener((ChangeListener<? super Boolean>)((ChangeListener<Boolean>)(observable2, oldValue, newValue) -> this.reloadChildren()));
            this.toolbarMenuTable.getItems().addAll(tableItem);
        }
    }

    private void reloadChildren() {
        this.content.getChildren().clear();
        this.toolbarMenuTable.getItems().stream().filter(CustomizableItem::isVisible).map(BottomToolbarItem::getToolbarNode).forEach(this.content.getChildren()::add);
    }

    public BottomToolbarStoredState getState() {
        List<BottomToolbarItemState> itemStates = this.toolbarMenuTable.getItems().stream().map(BottomToolbarItemState::new).toList();
        return new BottomToolbarStoredState(itemStates);
    }

    public void applyToolbarItemState(BottomToolbarStoredState state) {
        if (state != null) {
            this.toolbarMenuTable.getItems().removeIf(item -> item.getId().startsWith("separator_"));
            ArrayList itemsCopy = new ArrayList(this.toolbarMenuTable.getItems());
            this.toolbarMenuTable.getItems().clear();
            ArrayList<BottomToolbarItemState> storedItems = new ArrayList<BottomToolbarItemState>(state.getItems());
            for (BottomToolbarItemState storedItem : storedItems) {
                String itemId = storedItem.getComponentId();
                if (itemId.startsWith("separator_")) {
                    this.toolbarMenuTable.addSeparator();
                    continue;
                }
                Optional<BottomToolbarItem> possibleMatchingItem = itemsCopy.stream().filter(item -> item.getId().equals(itemId)).findFirst();
                if (!possibleMatchingItem.isPresent()) continue;
                BottomToolbarItem matchingItem = possibleMatchingItem.get();
                Node toolbarNode = matchingItem.getToolbarNode();
                matchingItem.setShowLabel(storedItem.isShowLabel());
                matchingItem.setVisible(storedItem.isVisible());
                this.toolbarMenuTable.getItems().add(matchingItem);
                if (toolbarNode instanceof StorableBottomToolbarNode) {
                    ((StorableBottomToolbarNode)((Object)toolbarNode)).restoreSavedState(storedItem.getState());
                }
                itemsCopy.remove(matchingItem);
            }
            this.toolbarMenuTable.getItems().addAll(itemsCopy);
        }
    }

    public ObservableList<Node> getToolbarItems() {
        return this.content.getChildren();
    }

    @FXML
    public void showComponents() {
        ToolbarPopup toolbarPopup = new ToolbarPopup(this.appContext, this.toolbarMenuTable, Util.getLabel("toolbarMenuTabel_bottomToolbar_hint"));
        toolbarPopup.show(this.title);
    }

    public void removeFromToolbarItemList(String id) {
        this.toolbarMenuTable.getItems().stream().filter(item -> id.equals(item.getId())).findFirst().ifPresent(this::removeItem);
    }

    private void removeItem(BottomToolbarItem item) {
        this.toolbarMenuTable.getItems().remove(item);
        if (item.getToolbarNode() instanceof Destroyable) {
            ((Destroyable)((Object)item.getToolbarNode())).destroy();
        }
    }

    @Override
    public void destroy() {
        this.toolbarMenuTable.getItems().stream().map(BottomToolbarItem::getToolbarNode).filter(Destroyable.class::isInstance).map(Destroyable.class::cast).forEach(Destroyable::destroy);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

