/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.instruments;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderLimitQueries;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.RiskSet;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.instruments.InstrumentProperty;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Optional;
import javafx.scene.control.TableView;
import org.apache.commons.lang3.ObjectUtils;

public class InstrumentsTableView
extends TableView<InstrumentProperty> {
    private LocalService localService;
    private OrderbookQueries orderbookQueries;
    private OrderLimitQueries orderLimitQueries;
    private SmallFastDataModel<Long, RiskSet> riskSetDataModel;

    public InstrumentsTableView() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected InstrumentsTableView(ApplicationContext applicationContext) {
        this.localService = applicationContext.getService(LocalService.class);
        this.orderbookQueries = applicationContext.getService(OrderbookQueries.class);
        this.orderLimitQueries = applicationContext.getService(OrderLimitQueries.class);
        this.riskSetDataModel = applicationContext.getSmallDataModel(RiskSet.class);
        FXMLLoaderWithContext.loadCustomComponent(applicationContext, this);
    }

    public void selectProduct(Product product) {
        this.getItems().clear();
        this.addProperty("commons_exchange", product.getExchange().getDisplayName());
        this.addProperty("commons_productType", product.getProductType().name());
        this.addProperty("commons_timeZone", product.getTimeZone());
        this.addProperty("commons_currency", product.getCurrencyCode());
        this.addProperty("commons_quantityUnit", product.getQuantityUnit());
        this.addProperty("commons_groupName", product.getGroupName() == null ? "" : product.getGroupName());
        this.addProperty("commons_baseProduct", product.getBaseProductId() == null ? "" : product.getBaseProductId());
        this.addProperty("commons_masterProduct", product.getMasterProductId() == null ? "" : product.getMasterProductId());
        this.addProperty("commons_linkedProduct", product.getLinkedProductId() == null ? "" : product.getLinkedProductId());
        this.addProperty("commons_executionRestriction", product.getExecutionRestriction() == null ? "" : product.getExecutionRestriction().getDisplayName());
        this.addProperty("commons_priceMinimalValue", product.getPriceMinValue());
        this.addProperty("commons_priceMaximalValue", product.getPriceMaxValue());
        this.addProperty("instrumentsPanel_details_priceTickSize", product.getPriceTickSize());
        this.addProperty("instrumentsPanel_details_quantityMinValue", product.getQuantityMinValue());
        Optional<OrderLimit> orderLimit = this.orderLimitQueries.findOrderLimitForProduct(product);
        this.addProperty("commons_quantityMaxValue", orderLimit.map(OrderLimit::getMaxQuanity).orElseGet(product::getQuantityMaxValue));
        if (orderLimit.isPresent()) {
            this.addProperty("commons_amount_maximum_value", orderLimit.get().getMaxAmount().getValue() == 0L ? Util.getLabel("commons_NotAvailableShort") : orderLimit.get().getMaxAmount().getDisplayValue());
        } else {
            this.addProperty("commons_amount_maximum_value", product.getAmountMaxValue() == null || product.getAmountMaxValue().getValue() == 0L ? Util.getLabel("commons_NotAvailableShort") : product.getAmountMaxValue());
        }
        this.addProperty("instrumentsPanel_details_quantityLotSize", product.getQuantityLotSize());
        this.addProperty("instrumentsPanel_details_deliveryUnits", product.getDeliveryUnits());
        this.addProperty("productConfigInfo_ICEBERG_ORDER_PRODUCT", product.isIcebergOrdersSupported());
        if (product.isIcebergOrdersSupported()) {
            this.addProperty("productConfigInfo_ICEBERG_MIN_PEAK_SIZE", product.getIcebergMinPeakSize());
            this.addProperty("productConfigInfo_ICEBERG_PRICE_DELTA_RANGE", product.getIcebergPriceDeltaRange());
        }
        this.addProperty("productConfigInfo_LIFT_ORDER_PRODUCT", product.isLiftOrderProduct());
        this.addProperty("productConfigInfo_LINKED_ORDER_PRODUCT", product.isLinkedOrderProduct());
        this.addProperty("productConfigInfo_OTC_PRODUCT", product.isOtcTradingSupported());
        this.addProperty("productConfigInfo_OTC_ONLY", product.isOtcOnlyProduct());
        this.addProperty("productConfigInfo_STOP_ORDER_PRODUCT", product.isStopOrderSupported());
        this.addProperty("productConfigInfo_PRIVATE_AND_CONFIDENTIAL", product.isPrivateAndConfidential());
        this.addProperty("productConfigInfo_ON_EXCHANGE_PREARRANGED_TRADE", product.isOnExchangePrearrangedTrade());
        Optional<RiskSet> riskSet = Optional.ofNullable((RiskSet)this.riskSetDataModel.findById(product.getRiskSetId()));
        if (riskSet.isPresent()) {
            this.addProperty("productConfigInfo_RISK_SET_POS_BUY_ORDER", true, riskSet.get().getPosBuyOrder());
            this.addProperty("productConfigInfo_RISK_SET_POS_SELL_ORDER", true, riskSet.get().getPosSellOrder());
            this.addProperty("productConfigInfo_RISK_SET_POS_BUY_TRADE", true, riskSet.get().getPosBuyTrade());
            this.addProperty("productConfigInfo_RISK_SET_POS_SELL_TRADE", true, riskSet.get().getPosSellTrade());
            this.addProperty("productConfigInfo_RISK_SET_NEG_BUY_ORDER", true, riskSet.get().getNegBuyOrder());
            this.addProperty("productConfigInfo_RISK_SET_NEG_SELL_ORDER", true, riskSet.get().getNegSellOrder());
            this.addProperty("productConfigInfo_RISK_SET_NEG_BUY_TRADE", true, riskSet.get().getNegBuyTrade());
            this.addProperty("productConfigInfo_RISK_SET_NEG_SELL_TRADE", true, riskSet.get().getNegSellTrade());
            this.addProperty("productConfigInfo_RISK_SET_ALPHA_BUY_ORDER", true, riskSet.get().getAlphaBuyOrder());
            this.addProperty("productConfigInfo_RISK_SET_ALPHA_SELL_ORDER", true, riskSet.get().getAlphaSellOrder());
            this.addProperty("productConfigInfo_RISK_SET_ALPHA_BUY_TRADE", true, riskSet.get().getAlphaBuyTrade());
            this.addProperty("productConfigInfo_RISK_SET_ALPHA_SELL_TRADE", true, riskSet.get().getAlphaSellTrade());
        }
    }

    public void selectContract(Contract contract) {
        this.getItems().clear();
        this.addProperty("commons_exchange", contract.getExchange().getDisplayName());
        this.addProperty("commons_contractStatus", contract.getCompoundStatus().getContractStatus().getDisplayName());
        this.addProperty("commons_product", contract.getProduct().getDisplayName());
        this.addProperty("commons_productType", contract.getProductType().name());
        this.addProperty("commons_activationPoint", this.localService.formatDateTime(contract.getActivationPoint(), contract.getProduct().getTimeZone()));
        this.addProperty("commons_expiryPoint", this.localService.formatDateTime(contract.getExpiryPoint(), contract.getProduct().getTimeZone()));
        this.addProperty("commons_deliveryStart", this.localService.formatDateTime(contract.getDeliveryStart(), contract.getProduct().getTimeZone()));
        this.addProperty("commons_deliveryEnd", this.localService.formatDateTime(contract.getDeliveryEnd(), contract.getProduct().getTimeZone()));
        this.addProperty("commons_canonical", contract.getType().isCanonical());
        if (contract.isOption()) {
            this.addProperty("commons_strikePrice", contract.getStrikePrc());
            this.addProperty("commons_putOrCall", contract.getPutOrCall().name());
        }
        for (Orderbook orderbook : this.orderbookQueries.findByContract(contract).stream().sorted((o1, o2) -> ObjectUtils.compare(o1.getDeliveryArea().getDisplayName(), o2.getDeliveryArea().getDisplayName())).toList()) {
            this.addTranslatedProperty(Util.getLabel("commons_deliveryArea") + " " + orderbook.getDeliveryArea().getDisplayName() + " - " + Util.getLabel("commons_tradingPhase"), null, orderbook.getTradingPhase());
            this.addTranslatedProperty(Util.getLabel("commons_deliveryArea") + " " + orderbook.getDeliveryArea().getDisplayName() + " - " + Util.getLabel("commons_contractState"), null, orderbook.getContractStatus());
        }
    }

    private void addProperty(String labelKey, Object value) {
        this.addProperty(labelKey, false, value);
    }

    private void addProperty(String labelKey, boolean showHint, Object value) {
        this.addTranslatedProperty(Util.getLabel(labelKey), showHint ? Util.getLabel("productConfigInfo_RISK_SET_HINT") : null, value);
    }

    private void addProperty(String labelKey, boolean value) {
        this.addProperty(labelKey, value ? Util.getLabel("commons_yes") : Util.getLabel("commons_no"));
    }

    private void addTranslatedProperty(String label, String hint, Object value) {
        if (value != null) {
            this.getItems().add(new InstrumentProperty(label, value.toString(), hint));
        }
    }

    public void clear() {
        this.getItems().clear();
    }
}

