/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract;

import com.deutscheboerse.comxerv.comtrader.entities.BespokeContract;
import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.contract.ContractFieldWrapper;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class SingleContractFieldWrapper
implements ContractFieldWrapper {
    private final ContractField contractField;
    private final ObjectProperty<Contract> value;
    private boolean changing;

    public SingleContractFieldWrapper(ContractField contractField) {
        this.contractField = contractField;
        contractField.showValidationWarningIfContractIsInactive();
        this.value = new SimpleObjectProperty<Contract>();
        this.value.addListener((observable2, oldValue, newValue) -> {
            if (!this.changing) {
                contractField.setText(newValue == null ? "" : newValue.getName());
                this.value.setValue((Contract)newValue);
            }
        });
        contractField.valueProperty().addListener((observable2, oldValue, newValue) -> {
            this.changing = true;
            this.value.setValue((Contract)newValue);
            this.changing = false;
        });
    }

    @Override
    public boolean canHandleContract(Contract contract) {
        return contract != null && !(contract instanceof BespokeContract) && !(contract instanceof BlockContract);
    }

    @Override
    public ObjectProperty<Contract> valueProperty() {
        return this.value;
    }

    @Override
    public BooleanProperty disabledProperty() {
        return this.contractField.disableProperty();
    }

    @Override
    public void reset() {
        this.contractField.setText("");
    }
}

