/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.GanttChartBarFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.LabeledBar;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.OrderbookLabeledBar;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MagnifiedOrderbookPopupService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.SingleContractOrderbookEvent;
import com.google.common.eventbus.EventBus;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.layout.StackPane;

public class ContractGanttChartBarFactory
implements GanttChartBarFactory<Contract, OrderbookLabeledBar> {
    private final MagnifiedOrderbookPopupService magnifiedOrderbookPopupService;
    private final OrderbookQueries orderbookQueries;
    private final EventBus eventBus;
    private final ObservableValue<DeliveryArea> deliveryAreaObservableValue;
    private final ApplicationContext appContext;

    public ContractGanttChartBarFactory(ApplicationContext applicationContext, ObservableValue<DeliveryArea> deliveryAreaObservableValue) {
        this.magnifiedOrderbookPopupService = applicationContext.getService(MagnifiedOrderbookPopupService.class);
        this.orderbookQueries = applicationContext.getService(OrderbookQueries.class);
        this.eventBus = applicationContext.getService(EventBus.class);
        this.deliveryAreaObservableValue = deliveryAreaObservableValue;
        this.appContext = applicationContext;
    }

    @Override
    public LabeledBar call(OrderbookLabeledBar container, Contract contract) {
        OrderbookLabeledBar currentContainer = container == null ? new OrderbookLabeledBar(this.appContext) : container;
        currentContainer.textProperty().bind(contract.nameProperty());
        StackPane bar = currentContainer.getBar();
        currentContainer.setOnMouseClicked(mouseEvent -> {
            Optional<Orderbook> orderbook = this.getOrderbook(contract);
            if (orderbook.isPresent()) {
                SingleContractOrderbookEvent event = new SingleContractOrderbookEvent(orderbook.get(), currentContainer);
                this.eventBus.post(event);
                if (!event.wasProcessed()) {
                    this.magnifiedOrderbookPopupService.showMagnifiedOrderbookPopup(orderbook.get(), currentContainer);
                }
            }
        });
        this.deliveryAreaObservableValue.addListener(observable2 -> this.reloadOrderbook(contract, currentContainer));
        this.reloadOrderbook(contract, currentContainer);
        bar.pseudoClassStateChanged(PseudoClass.getPseudoClass(contract.getCompoundStatus().getContractStatus().getDisplayName()), true);
        contract.getCompoundStatus().contractStatusProperty().addListener((observable2, oldValue, newValue) -> {
            bar.pseudoClassStateChanged(PseudoClass.getPseudoClass(oldValue.getDisplayName()), false);
            bar.pseudoClassStateChanged(PseudoClass.getPseudoClass(newValue.getDisplayName()), true);
        });
        return currentContainer;
    }

    private void reloadOrderbook(Contract contract, OrderbookLabeledBar currentContainer) {
        Optional<Orderbook> orderbook = this.getOrderbook(contract);
        if (orderbook.isPresent()) {
            currentContainer.loadLastPrcQty(orderbook.get());
            currentContainer.loadPriceChange(orderbook.get());
        }
    }

    private Optional<Orderbook> getOrderbook(Contract contract) {
        DeliveryArea selectedDeliveryArea = this.deliveryAreaObservableValue.getValue();
        return this.orderbookQueries.findByContractAndDeliveryArea(contract, selectedDeliveryArea);
    }
}

