/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.GanttChartBarFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.producttimeline.LabeledBar;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import org.joda.time.DateTime;

public class GanttChart<S, R extends LabeledBar>
extends XYChart<Number, String> {
    private DoubleProperty blockHeight = new SimpleDoubleProperty(40.0);
    private final Line currentTimeLine = new Line();
    private final ObjectProperty<DateTime> currentTime = new SimpleObjectProperty<DateTime>(new DateTime());
    private ObjectProperty<GanttChartBarFactory<S, R>> barFactory = new SimpleObjectProperty<GanttChartBarFactory<Object, LabeledBar>>((currentBar, item) -> currentBar == null ? new LabeledBar() : currentBar);

    public GanttChart(@NamedArg(value="xAxis") Axis<Number> xAxis, @NamedArg(value="yAxis") Axis<String> yAxis) {
        super(xAxis, yAxis);
        this.setAnimated(false);
        this.setData(FXCollections.observableArrayList());
        this.currentTimeLine.setStartY(0.0);
        this.currentTimeLine.endYProperty().bind(this.heightProperty());
        StyleUtil.addStyleClass(this.currentTimeLine, "currentTime");
        DependentBinding<Number> currentTimeOnXAxis = new DependentBinding<Number>(new Observable[]{this.currentTime}){

            @Override
            protected Number computeValue() {
                return GanttChart.this.getXAxis().getDisplayPosition(((DateTime)GanttChart.this.currentTime.get()).getMillis());
            }
        };
        this.currentTimeLine.endXProperty().bind(currentTimeOnXAxis);
        this.currentTimeLine.startXProperty().bind(currentTimeOnXAxis);
        this.getPlotChildren().add(this.currentTimeLine);
    }

    public ObjectProperty<DateTime> currentTimeProperty() {
        return this.currentTime;
    }

    private static double getLength(Object obj) {
        long millis = ((Contract)obj).getDeliveryDuration().getMillis();
        return Math.abs(millis);
    }

    @Override
    protected void layoutPlotChildren() {
        for (XYChart.Series series : this.getData()) {
            Iterator iter = this.getDisplayedDataIterator(series);
            while (iter.hasNext()) {
                Rectangle ellipse;
                XYChart.Data item = iter.next();
                double x = this.getXAxis().getDisplayPosition((Number)item.getXValue());
                double y = this.getYAxis().getDisplayPosition((String)item.getYValue());
                if (Double.isNaN(x) || Double.isNaN(y) || item.getNode() == null || !(item.getNode() instanceof LabeledBar)) continue;
                LabeledBar labeledBar = (LabeledBar)item.getNode();
                StackPane bar = labeledBar.getBar();
                if (bar.getShape() == null) {
                    ellipse = new Rectangle(GanttChart.getLength(item.getExtraValue()), this.getBlockHeight());
                } else if (labeledBar.getBar().getShape() instanceof Rectangle) {
                    ellipse = (Rectangle)labeledBar.getBar().getShape();
                } else {
                    return;
                }
                ellipse.setWidth(GanttChart.getLength(item.getExtraValue()) * (this.getXAxis() instanceof NumberAxis ? Math.abs(((NumberAxis)this.getXAxis()).getScale()) : 1.0));
                ellipse.setHeight(this.getBlockHeight());
                y -= this.getBlockHeight() / 2.0;
                bar.setShape(null);
                bar.setShape(ellipse);
                bar.setScaleShape(false);
                bar.setCenterShape(false);
                bar.setCacheShape(true);
                labeledBar.getContrainer().toFront();
                labeledBar.getContrainer().setMaxWidth(ellipse.getWidth());
                labeledBar.getContrainer().setLayoutY((this.getBlockHeight() - labeledBar.getContrainer().getHeight()) / 2.0);
                labeledBar.getContrainer().setLayoutX(2.0);
                labeledBar.setLayoutX(x);
                labeledBar.setLayoutY(y);
            }
        }
        this.currentTimeLine.toFront();
    }

    public double getBlockHeight() {
        return this.blockHeight.get();
    }

    public DoubleProperty blockHeightProperty() {
        return this.blockHeight;
    }

    public void setBlockHeight(double blockHeight) {
        this.blockHeight.set(blockHeight);
    }

    @Override
    protected void dataItemAdded(XYChart.Series<Number, String> series, int itemIndex, XYChart.Data<Number, String> item) {
        Node block = this.createContainer(item);
        this.getPlotChildren().add(block);
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<Number, String> item, XYChart.Series<Number, String> series) {
        Node block = item.getNode();
        this.getPlotChildren().remove(block);
        this.removeDataItemFromDisplay(series, item);
    }

    @Override
    protected void dataItemChanged(XYChart.Data<Number, String> item) {
    }

    @Override
    protected void seriesAdded(XYChart.Series<Number, String> series, int seriesIndex) {
        for (int j = 0; j < series.getData().size(); ++j) {
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node container = this.createContainer(item);
            this.getPlotChildren().add(container);
        }
    }

    @Override
    protected void seriesRemoved(XYChart.Series<Number, String> series) {
        for (XYChart.Data data : series.getData()) {
            Node container = data.getNode();
            this.getPlotChildren().remove(container);
        }
        this.removeSeriesFromDisplay(series);
    }

    private Node createContainer(XYChart.Data<Number, String> item) {
        LabeledBar call = ((GanttChartBarFactory)this.barFactory.get()).call((LabeledBar)item.getNode(), item.getExtraValue());
        StyleUtil.addStyleClass(call.getBar(), "diagramContract");
        item.setNode(call);
        return call;
    }

    public final void setCellFactory(GanttChartBarFactory<S, R> value) {
        this.barFactory.set(value);
    }

    @Override
    protected void updateAxisRange() {
        Axis xa = this.getXAxis();
        Axis ya = this.getYAxis();
        ArrayList<Number> xData = null;
        ArrayList<String> yData = null;
        if (xa.isAutoRanging()) {
            xData = new ArrayList<Number>();
        }
        if (ya.isAutoRanging()) {
            yData = new ArrayList<String>();
        }
        if (xData != null || yData != null) {
            for (XYChart.Series series : this.getData()) {
                for (XYChart.Data data : series.getData()) {
                    if (xData != null) {
                        xData.add((Number)data.getXValue());
                        xData.add((Number)xa.toRealValue(xa.toNumericValue((Number)data.getXValue()) + GanttChart.getLength(data.getExtraValue())));
                    }
                    if (yData == null) continue;
                    yData.add((String)data.getYValue());
                }
            }
            if (xData != null) {
                xa.invalidateRange(xData);
            }
            if (yData != null) {
                ya.invalidateRange(yData);
            }
        }
    }
}

