/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AccountTypeChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.CanonicalContractField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ContractField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DeliveryAreaChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.OpenCloseIndicatorChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.OrderTypeChoiceBoxCx;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SettingsPanelProductField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SimpleLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ValidityRestrictionChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurations;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.TableViewOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesEntry;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import org.apache.commons.lang3.StringUtils;

@OverrideGuiConfigurations(value={@OverrideGuiConfiguration(field="#this", overrideId="OrderPreferencesPane", strategy=AllDescendantsByIdOverrideGuiStrategy.class), @OverrideGuiConfiguration(field="preferencesTableView", overrideId="OrderPreferencesPane", strategy=TableViewOverrideGuiStrategy.class)})
public class OrderPreferencesPane
extends BorderPane
implements SettingsSection {
    private final ObjectProperty<OrderPreferencesEntry> currentOrderPreferencesEntry;
    private final BooleanProperty modifying = new SimpleBooleanProperty(false);
    private final BooleanProperty valid = new SimpleBooleanProperty(false);
    private final UserAlertService userAlertService;
    private final OrderPreferencesService orderPreferencesService;
    private final UserService userService;
    private final OverrideGuiConfigurationsExecutor overrideGuiConfigurationsExecutor;
    private final ChangeListener<Exchange> activeExchangeChange;
    @FXML
    private Button addButton;
    @FXML
    private Button modifyButton;
    @FXML
    private Button deleteOrCancelButton;
    @FXML
    private TableView<OrderPreferencesEntry> preferencesTableView;
    @FXML
    private SettingsPanelProductField productField;
    @FXML
    private CanonicalContractField contractField;
    @FXML
    private SimpleLongDisplayValueField quantityField;
    @FXML
    private OrderTypeChoiceBoxCx orderTypeField;
    @FXML
    private DeliveryAreaChoiceBox deliveryAreaChoiceBox;
    @FXML
    private AccountTypeChoiceBox accountTypeChoiceBox;
    @FXML
    private ValidityRestrictionChoiceBox valResChoiceBox;
    @FXML
    private OpenCloseIndicatorChoiceBox openCloseIndicatorField;
    private ObservableValue<Exchange> activeExchange;

    public OrderPreferencesPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OrderPreferencesPane(ApplicationContext appContext) {
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.orderPreferencesService = appContext.getService(OrderPreferencesService.class);
        this.userService = appContext.getService(UserService.class);
        this.overrideGuiConfigurationsExecutor = appContext.getService(OverrideGuiConfigurationsExecutor.class);
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
        this.currentOrderPreferencesEntry = new SimpleObjectProperty<OrderPreferencesEntry>(new OrderPreferencesEntry());
        this.activeExchangeChange = (observable2, oldValue, newValue) -> this.resetBalanceUserProperty();
        this.activeExchange.addListener(new WeakChangeListener<Exchange>(this.activeExchangeChange));
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        this.preferencesTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.addButton.disableProperty().bind(this.modifying.or(this.valid.not()));
        this.deleteOrCancelButton.disableProperty().bind(this.modifying.not().and(Bindings.isEmpty(this.preferencesTableView.getSelectionModel().getSelectedItems())));
        this.modifyButton.disableProperty().bind(this.modifying.and(this.valid.not()).or(this.modifying.not().and(Bindings.size(this.preferencesTableView.getSelectionModel().getSelectedItems()).isNotEqualTo(1))));
        this.addButton.visibleProperty().bind(this.modifying.not());
        this.modifying.addListener((observable2, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.deleteOrCancelButton.setText(Util.getLabel("commons_cancel"));
            } else {
                this.deleteOrCancelButton.setText(Util.getLabel("commons_remove"));
            }
        });
        this.contractField.productProperty().bind(this.productField.valueProperty());
        this.contractField.setMode(ContractField.Mode.PRODUCT_SPECIFIC);
        this.productField.valueProperty().addListener((observable2, oldValue, newValue) -> this.contractField.setText(""));
        this.productField.setPromptText("*");
        this.contractField.setPromptText("*");
        this.orderTypeField.contractProperty().bind(this.contractField.valueProperty());
        this.deliveryAreaChoiceBox.contractProperty().bind(this.contractField.valueProperty());
        DependentBinding<LongDisplayValue> minimumQuantityBinding = DependentBinding.get(Product::getQuantityMinValue, this.productField.valueProperty(), LongDisplayValue.ZERO);
        DependentBinding<LongDisplayValue> maximumQuantityBinding = DependentBinding.get(Product::getQuantityMaxValue, this.productField.valueProperty(), new LongDisplayValue(Integer.MAX_VALUE, 0));
        this.quantityField.minimumProperty().bind(minimumQuantityBinding);
        this.quantityField.maximumProperty().bind(maximumQuantityBinding);
        this.productField.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null) {
                LongDisplayValue oldQuantity = this.quantityField.getValue();
                this.quantityField.setValue((oldQuantity != null ? oldQuantity : LongDisplayValue.ZERO).applyShift(newValue.getQuantityDecimalShift()));
                this.quantityField.setDelta((int)newValue.getQuantityLotSize().getValue());
            } else {
                LongDisplayValue oldQuantity = this.quantityField.getValue();
                this.quantityField.setValue(oldQuantity != null ? oldQuantity : LongDisplayValue.ZERO);
                this.quantityField.setDelta(1);
            }
        });
        this.valid.bind(this.productField.validProperty().and(this.contractField.validProperty().and(this.quantityField.validProperty())));
        this.resetEntryForm();
        this.restoreState();
        this.overrideGuiConfigurationsExecutor.registerAndApply(this);
    }

    private void resetBalanceUserProperty() {
        this.orderTypeField.init(true, this.userService.getCurrentUser() != null && this.userService.getCurrentUser().getRoles().isBalanceUser(), false, null);
    }

    private void resetEntryForm() {
        this.productField.textProperty().setValue("");
        this.contractField.textProperty().setValue("");
        this.quantityField.setValue(null);
        this.orderTypeField.setValue((OrderType)this.orderTypeField.getListedItems().get(0));
        this.deliveryAreaChoiceBox.setValue(this.deliveryAreaChoiceBox.getListedItems().get(0));
        this.accountTypeChoiceBox.reset();
        this.resetBalanceUserProperty();
    }

    @FXML
    public void addOrderPreferencesEntry() {
        if (this.isValidOrderPreferencesEntry()) {
            OrderPreferencesEntry newEntry = (OrderPreferencesEntry)this.currentOrderPreferencesEntry.get();
            this.ruleModificationFinished();
            this.preferencesTableView.getItems().add(newEntry);
            this.resetEntryForm();
            this.currentOrderPreferencesEntry.setValue(new OrderPreferencesEntry());
        }
    }

    @FXML
    public void modifyOrderPreferencesEntry() {
        OrderPreferencesEntry selectedItem = (OrderPreferencesEntry)this.preferencesTableView.getSelectionModel().getSelectedItem();
        if (this.modifying.get()) {
            if (this.isValidOrderPreferencesEntry()) {
                this.ruleModificationFinished();
            }
        } else if (selectedItem != null) {
            this.startRuleModification(selectedItem);
        }
    }

    private void ruleModificationFinished() {
        OrderPreferencesEntry orderEntryRule = (OrderPreferencesEntry)this.currentOrderPreferencesEntry.get();
        orderEntryRule.setProduct(StringUtils.isEmpty(this.productField.getText()) ? "*" : this.productField.getText());
        orderEntryRule.setContract(StringUtils.isEmpty(this.contractField.getText()) ? "*" : this.contractField.getText());
        orderEntryRule.setQuantity(this.quantityField.getValue());
        orderEntryRule.setOrderType((OrderType)this.orderTypeField.getValue());
        orderEntryRule.setDeliveryArea((DeliveryArea)this.deliveryAreaChoiceBox.getValue());
        orderEntryRule.setAccountType((String)this.accountTypeChoiceBox.getValue());
        orderEntryRule.setValidityRestriction((ValidityRestriction)this.valResChoiceBox.getValue());
        orderEntryRule.setOpenOrClose((OpenOrClose)this.openCloseIndicatorField.getValue());
        this.modifying.setValue(false);
        this.resetEntryForm();
        this.currentOrderPreferencesEntry.setValue(new OrderPreferencesEntry());
    }

    private void startRuleModification(OrderPreferencesEntry selectedItem) {
        this.modifying.setValue(true);
        this.resetEntryForm();
        this.productField.setText(selectedItem.getProduct().equals("*") ? "" : selectedItem.getProduct());
        this.contractField.setText(selectedItem.getContract().equals("*") ? "" : selectedItem.getContract());
        this.quantityField.setValue(selectedItem.getQuantity());
        this.orderTypeField.setValue(selectedItem.getOrderType());
        this.deliveryAreaChoiceBox.setValue(selectedItem.getDeliveryArea());
        this.accountTypeChoiceBox.setValue(selectedItem.getAccountType());
        this.valResChoiceBox.setValue(selectedItem.getValidityRestriction());
        this.openCloseIndicatorField.setValue(selectedItem.getOpenOrClose());
        this.currentOrderPreferencesEntry.setValue(selectedItem);
    }

    private boolean isValidOrderPreferencesEntry() {
        if (this.isOrderPreferencesAlreadyExist()) {
            this.userAlertService.showConfirmationDialog(Util.getLabel("commons_error"), Util.getLabel("settingsPanel_orderPreferencesTab_alreadyExists"), UserAlertService.Flag.ERROR);
            return false;
        }
        return true;
    }

    private boolean isOrderPreferencesAlreadyExist() {
        for (OrderPreferencesEntry entry : this.preferencesTableView.getItems()) {
            if (entry.equals(this.currentOrderPreferencesEntry.get()) || !entry.getProduct().equals(this.productField.getValue() != null ? ((Product)this.productField.getValue()).getDisplayName() : "*") || !entry.getContract().equals(this.contractField.getValue() != null ? ((Contract)this.contractField.getValue()).getDisplayName() : "*")) continue;
            return true;
        }
        return false;
    }

    @FXML
    public void deleteOrCancelOrderPreferencesEntry() {
        if (this.modifying.getValue().booleanValue()) {
            this.modifying.setValue(false);
            this.resetEntryForm();
        } else {
            ObservableList deleteIndices = this.preferencesTableView.getSelectionModel().getSelectedIndices();
            for (int i = deleteIndices.size() - 1; i >= 0; --i) {
                this.preferencesTableView.getItems().remove((Integer)deleteIndices.get(i));
            }
        }
    }

    @Override
    public boolean applyChanges() {
        this.orderPreferencesService.storeOrderPreferences(this.preferencesTableView.getItems());
        return true;
    }

    @Override
    public void cancelChanges() {
        this.restoreState();
    }

    @Override
    public void resetToDefault() {
        this.preferencesTableView.getItems().clear();
        this.resetEntryForm();
    }

    private void restoreState() {
        this.preferencesTableView.setItems(FXCollections.observableArrayList(this.orderPreferencesService.getOrderPreferences()));
    }

    public TableView<OrderPreferencesEntry> getPreferencesTableView() {
        return this.preferencesTableView;
    }
}

