/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.TableColumnWithTooltip;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.column.ColumnToolbarMenuTable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.common.ToolbarPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomTableViewSkin<S>
extends TableViewSkin<S> {
    private static final Logger LOG = LoggerFactory.getLogger(CustomTableViewSkin.class);
    private final CustomTableView<S> tableView;
    private final ApplicationContext appContext;

    public CustomTableViewSkin(CustomTableView<S> tableView, ApplicationContext appContext) {
        super(tableView);
        this.tableView = tableView;
        this.appContext = appContext;
        this.getTableHeaderRow().getRootHeader().getColumnHeaders().addListener(c -> {
            for (TableColumnHeader h : c.getList()) {
                if (!(h.getTableColumn() instanceof TableColumnWithTooltip)) continue;
                TableColumnWithTooltip columnWithTooltip = (TableColumnWithTooltip)h.getTableColumn();
                Tooltip tooltip = new Tooltip(columnWithTooltip.getTooltipText());
                Tooltip.install(h, tooltip);
            }
        });
        this.addCustomTableMenu();
    }

    public void addCustomTableMenu() {
        Pane child = CustomTableViewSkin.getCornerRegion(this.getTableHeaderRow());
        if (child != null) {
            child.setOnMousePressed(me -> this.showComponents());
        }
    }

    private static Pane getCornerRegion(TableHeaderRow headerRow) {
        for (Node node : headerRow.getChildren()) {
            if (!(node instanceof StackPane) || !node.getStyleClass().contains("show-hide-columns-button")) continue;
            return (Pane)node;
        }
        LOG.error("Unable to find CornerRegion");
        return null;
    }

    private void showComponents() {
        ToolbarPopup toolbarPopup = new ToolbarPopup(this.appContext, new ColumnToolbarMenuTable((CustomTableView)this.getSkinnable(), this.appContext), Util.getLabel("toolbarMenuTabel_customColumn_hint"));
        toolbarPopup.show(this.tableView.getTitle());
    }
}

