/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.common;

import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellCustomizer;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.paint.Color;

public class DirectionCellCustomizer<S>
extends GenericCellCustomizer<S, Direction> {
    @Override
    protected Node getGraphic(Direction cellItem, S rowValue, Node defaultGraphic) {
        if (Direction.BUY == cellItem) {
            return new IconView(FontAwesomeIcon.ARROW_RIGHT, "icon-buy", Color.WHITE, -45.0);
        }
        if (Direction.SELL == cellItem) {
            return new IconView(FontAwesomeIcon.ARROW_RIGHT, "icon-sell", Color.WHITE, 45.0);
        }
        return null;
    }

    @Override
    protected void customizeTableCell(TableCell<S, Direction> tableCell) {
        Direction item = (Direction)tableCell.getItem();
        if (item != null) {
            StyleUtil.addStyleClass(tableCell, "buy", "sell", item.isBuy());
            tableCell.setContentDisplay(item.isBuy() ? ContentDisplay.RIGHT : ContentDisplay.LEFT);
        } else {
            tableCell.getStyleClass().removeAll((String[])new String[]{"buy", "sell"});
        }
    }
}

