/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.order;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu.OwnOrderContextMenuFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.order.OwnOrderRowTooltip;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.DependentObservableValue2;
import com.deutscheboerse.ui.jfx.util.event.DeselectionEventHandler;
import java.util.Collections;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.util.Callback;
import org.apache.commons.collections4.CollectionUtils;

public class OwnOrderRowFactory
implements Callback<TableView<Order>, TableRow<Order>> {
    private final ApplicationContext appContext;

    public OwnOrderRowFactory() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OwnOrderRowFactory(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public TableRow<Order> call(TableView<Order> orderTableView) {
        OwnOrderTableRow ownOrderTableRow = new OwnOrderTableRow(this.appContext);
        ownOrderTableRow.updateTableView(orderTableView);
        return ownOrderTableRow;
    }

    private static final class OwnOrderTableRow
    extends TableRow<Order> {
        private final InvalidationListener userChangedListener;
        private final UserService userService;
        private final ObservableValue<User> userObservable;
        private final DragAndDropService dragAndDropService;
        private final OwnOrderRowTooltip tooltip;
        private final ApplicationContext appContext;

        public OwnOrderTableRow(ApplicationContext appContext) {
            this.appContext = appContext;
            this.userService = appContext.getService(UserService.class);
            this.dragAndDropService = appContext.getService(DragAndDropService.class);
            this.tooltip = appContext.getService(OwnOrderRowTooltip.class);
            this.userChangedListener = observable2 -> this.setStyleForCurrentUser();
            this.userObservable = this.userService.currentUserProperty();
            this.userObservable.addListener(new WeakInvalidationListener(this.userChangedListener));
            this.setOnDragDetected(this::dragDetected);
            this.setOnMouseClicked(this::mouseClicked);
            this.setOnMouseEntered(mouseEvent -> this.tooltip.applyOrder((Order)this.getItem()));
            this.tooltipProperty().bind(DependentBinding.get(order -> order != null ? this.tooltip : null, this.itemProperty(), null, this.indexProperty()));
            DependentObservableValue2<Order, OrderStatus> tableRowStatus = new DependentObservableValue2<Order, OrderStatus>(this.itemProperty(), Order::statusProperty);
            tableRowStatus.addListener((observableValu, status, newStatus) -> StyleUtil.addStyleClass(this, "hibernate", newStatus == OrderStatus.HIBERNATE || newStatus == OrderStatus.UNKNOWN));
            this.setOnContextMenuRequested(contextMenuEvent -> {
                ObservableList selectedOrders = this.getTableView().getSelectionModel().getSelectedItems();
                if (CollectionUtils.isNotEmpty(selectedOrders)) {
                    this.setContextMenu(appContext.getService(OwnOrderContextMenuFactory.class).createOwnOrderContextMenu(selectedOrders));
                }
            });
            this.addEventFilter(MouseEvent.MOUSE_PRESSED, new DeselectionEventHandler<Order>(this));
            this.itemProperty().addListener((observableValue, order, newOrder) -> this.setStyleForCurrentUser());
        }

        private void dragDetected(MouseEvent event) {
            ObservableList selectedOrders = this.getTableView().getSelectionModel().getSelectedItems();
            Order orderTableRowItem = (Order)this.getItem();
            if (orderTableRowItem != null) {
                Dragboard db = this.startDragAndDrop(TransferMode.ANY);
                if (selectedOrders.contains(orderTableRowItem)) {
                    this.dragAndDropService.setOrderList(db, selectedOrders);
                } else {
                    this.dragAndDropService.setOrderList(db, Collections.singletonList(orderTableRowItem));
                }
                event.consume();
            }
        }

        private void mouseClicked(MouseEvent event) {
            Order order;
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 2 && (order = (Order)this.getItem()) != null) {
                this.appContext.getService(OrderPopup.class).showExtendedOrderPopup(order, false, (Node)event.getTarget());
            }
        }

        private void setStyleForCurrentUser() {
            StyleUtil.addStyleClass(this, "currentUser", "nonCurrentUser", this.isCurrentUser((Order)this.getItem()));
        }

        private boolean isCurrentUser(Order order) {
            if (order != null) {
                User user = (User)this.userService.currentUserProperty().get();
                return user != null && user.getUserCode().equals(order.getTraderUserCode()) && ((String)user.getMember().getId()).equals(order.getMemberCode());
            }
            return false;
        }
    }
}

