/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.ColorInvalidationListener;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.orderbook.ContractCellFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.service.SelectedCellService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.trade.TradingActionService;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.input.MouseEvent;

public class OrderbookContractCellFactory<O extends OrderbookValueWrapper>
extends ContractCellFactory<O> {
    private final ApplicationContext applicationContext = FXMLLoaderWithContext.getAppContext();

    @Override
    public TableCell<O, Contract> call(TableColumn<O, Contract> orderbookItemStringTableColumn) {
        OrderbookWrapperContractTableCell orderbookTextCell = new OrderbookWrapperContractTableCell(this.applicationContext, this.getAlignment());
        ColorInvalidationListener.registerForColoredTableColumn(orderbookItemStringTableColumn, orderbookTextCell);
        return orderbookTextCell;
    }

    protected static class OrderbookWrapperContractTableCell<O extends OrderbookValueWrapper>
    extends ContractCellFactory.ContractTableCell<O> {
        private final TradingActionService tradingActionService;
        private final SelectedCellService selectedCellService;
        private final EventHandler<MouseEvent> selectionListener;

        public OrderbookWrapperContractTableCell(ApplicationContext applicationContext, Pos alignment) {
            super(alignment);
            this.tradingActionService = applicationContext.getService(TradingActionService.class);
            this.selectedCellService = applicationContext.getService(SelectedCellService.class);
            this.selectionListener = this.selectedCellService.getListenerAsMouseEventHandler(this);
            StyleUtil.addStyleClass(this, "orderbookTextCell");
            this.setOnMouseClicked(this::onMouseClicked);
        }

        @Override
        protected void updateItem(Contract item, boolean empty) {
            super.updateItem(item, empty);
            this.selectedCellService.update(this);
            if (!empty && item != null) {
                this.addEventHandler(MouseEvent.MOUSE_CLICKED, this.selectionListener);
                this.addEventHandler(MouseEvent.DRAG_DETECTED, this.selectionListener);
            } else {
                this.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.selectionListener);
                this.removeEventHandler(MouseEvent.DRAG_DETECTED, this.selectionListener);
            }
        }

        private void onMouseClicked(MouseEvent mouseEvent) {
            if (this.getTableRow().getItem() instanceof OrderbookValueWrapper) {
                Orderbook orderbook = ((OrderbookValueWrapper)this.getTableRow().getItem()).getOrderbook();
                this.tradingActionService.doAction(mouseEvent, orderbook);
            }
        }
    }
}

