/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.jfx.service.SelectedCellService;
import com.google.inject.Singleton;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javax.annotation.Nonnull;

@Singleton
public class SelectedCellServiceImpl
implements SelectedCellService {
    private WeakReference<TableCell> selectedCell = new WeakReference<Object>(null);
    private WeakReference<TableView> selectedView = new WeakReference<Object>(null);
    private SimpleIntegerProperty selectedIndex = new SimpleIntegerProperty();
    private SimpleObjectProperty selectedObject = new SimpleObjectProperty();

    @Override
    public EventHandler<MouseEvent> getListenerAsMouseEventHandler(@Nonnull TableCell node) {
        return event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                this.select(node);
            }
        };
    }

    private void select(TableCell newSelectedCell) {
        TableCell oldCell = (TableCell)this.selectedCell.get();
        if (oldCell != null) {
            oldCell.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, false);
        }
        newSelectedCell.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, true);
        this.selectedCell = new WeakReference<TableCell>(newSelectedCell);
        this.selectedView = new WeakReference(newSelectedCell.getTableView());
        this.selectedIndex.set(newSelectedCell.getIndex());
        this.selectedObject.set(newSelectedCell.getItem());
    }

    @Override
    public void update(TableCell tableCell) {
        if (this.selectedCell.get() != null && this.selectedView.get() != null && ((TableView)this.selectedView.get()).equals(tableCell.getTableView()) && tableCell.getIndex() == this.selectedIndex.get() && Objects.equals(tableCell.getItem(), this.selectedObject.get())) {
            ((TableCell)this.selectedCell.get()).pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, false);
            tableCell.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, true);
            this.selectedCell = new WeakReference<TableCell>(tableCell);
        } else {
            tableCell.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, false);
        }
    }
}

