/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.flash;

import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlash;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.FlashDuration;
import java.util.function.Supplier;
import javafx.animation.AnimationTimer;
import javafx.geometry.Insets;
import javafx.scene.control.Labeled;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;

class AnimationTimerColorFlash
extends AnimationTimer
implements ColorFlash {
    public static final Insets FLASH_BACKGROUND_INSETS = new Insets(2.0);
    public static final CornerRadii FLASH_BACKGROUND_RADIUS = CornerRadii.EMPTY;
    private final Labeled labeled;
    private final Supplier<FlashDuration> duration;
    private final Supplier<Color> flashColorSupplier;
    private long end;
    private Color flashColor;
    private Color flashColorInverted;
    private Background flashBackground;

    public AnimationTimerColorFlash(Labeled labeled, Supplier<FlashDuration> duration, Supplier<Color> flashColorSupplier) {
        this.labeled = labeled;
        this.duration = duration;
        this.flashColorSupplier = flashColorSupplier;
        this.end = -1L;
    }

    @Override
    public void handle(long now) {
        if (this.end == -1L) {
            this.startFlash(now);
        } else if (now > this.end) {
            this.endFlash();
        } else {
            this.flashFrame();
        }
    }

    private void flashFrame() {
        this.labeled.setBackground(this.flashBackground);
        this.labeled.setTextFill(this.flashColorInverted);
    }

    private void startFlash(long now) {
        this.end = now + this.duration.get().getDurationInMillis() * 1000000L;
        Color currentFlashColor = this.flashColorSupplier.get();
        if (!currentFlashColor.equals(this.flashColor)) {
            this.flashColorChanged(currentFlashColor);
        }
    }

    protected void endFlash() {
        this.stop();
        this.end = -1L;
        this.labeled.setBackground(null);
        this.labeled.setTextFill(null);
        this.labeled.applyCss();
    }

    private void flashColorChanged(Color newColor) {
        this.flashBackground = new Background(new BackgroundFill(newColor, FLASH_BACKGROUND_RADIUS, FLASH_BACKGROUND_INSETS));
        this.flashColor = newColor;
        this.flashColorInverted = newColor.invert();
    }

    @Override
    public void flash(boolean abortPreviewsFlash) {
        if (this.end != -1L) {
            if (!abortPreviewsFlash) {
                return;
            }
            this.endFlash();
        }
        if (this.duration.get().getDurationInMillis() > 0L) {
            this.start();
        }
    }

    @Override
    public void abort() {
        if (this.end != -1L) {
            this.endFlash();
        }
    }
}

