/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.type.TradeState;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.TradePopupPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.TradesCanceledPopupPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.TradesPopupPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.service.WindowService;
import com.deutscheboerse.comxerv.comtrader.jfx.util.CloseAfterLogout;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeProcessingUserInterface;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.ModalStages;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Scene;
import javafx.stage.Stage;

@Singleton
public class TradePopupService
implements TradeProcessingUserInterface {
    private final WindowService windowService;
    private final EventBus eventBus;
    private final ApplicationContext applicationContext;

    @Inject
    public TradePopupService(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.windowService = applicationContext.getService(WindowService.class);
        this.eventBus = applicationContext.getService(EventBus.class);
    }

    @Override
    public void showTradesForProcessing(List<FullTrade> trades, TradeProcessingUserInterface.Mode mode, Consumer<TradeState> selectedUserAction) {
        Stage stage = new Stage();
        CloseAfterLogout.register(this.eventBus, stage);
        ModalStages.makeModal(stage);
        Consumer<TradeState> closeAndProcessUserAction = tradeState -> {
            selectedUserAction.accept((TradeState)tradeState);
            stage.close();
        };
        if (trades.size() == 1) {
            TradePopupPanel singleTradePanel = new TradePopupPanel(this.applicationContext, trades.get(0), closeAndProcessUserAction, mode);
            stage.setScene(new Scene(singleTradePanel));
        } else {
            TradesPopupPanel multiTradePanel = new TradesPopupPanel(this.applicationContext, trades, closeAndProcessUserAction, mode);
            stage.setScene(new Scene(multiTradePanel));
        }
        this.windowService.decorateWindow(stage);
        if (TradeProcessingUserInterface.Mode.CANCEL == mode) {
            stage.setTitle(Util.getLabel("tradeCancellationConfirmationPanel_cancel_title"));
        } else if (TradeProcessingUserInterface.Mode.CREATE == mode) {
            stage.setTitle(Util.getLabel("bespokeTradesPanel_prearrangedTradeConfirmation_title"));
        } else {
            stage.setTitle(Util.getLabel("commons_processTrade"));
        }
        stage.setWidth(590.0);
        stage.setResizable(false);
        stage.show();
    }

    @Override
    public void showTradesCancelledPopup(List<FullTrade> trades, int cancelled, int failures) {
        Stage stage = new Stage();
        CloseAfterLogout.register(this.eventBus, stage);
        ModalStages.makeModal(stage);
        stage.setScene(new Scene(new TradesCanceledPopupPanel(this.applicationContext, trades, cancelled, failures, stage::close)));
        this.windowService.decorateWindow(stage);
        stage.setTitle(Util.getLabel("tradeCancellationConfirmationPanel_cancel_title"));
        stage.setWidth(590.0);
        stage.setResizable(false);
        stage.show();
    }
}

