/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.util;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.domain.query.DeliveryAreaQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import java.util.ArrayList;
import java.util.List;

class SerializedOrder {
    private final Exchange exchange;
    private final String balancingGroupId;
    private final Direction direction;
    private final String accountType;
    private final Long contractId;
    private final String deliveryAreaName;
    private final OrderType orderType;
    private final ExecutionRestriction executionRestriction;
    private final ValidityRestriction validityRestriction;
    private final OpenOrClose openOrClose;
    private final OrderStatus orderStatus;
    private final LongDisplayValue limitedPrice;
    private final LongDisplayValue remainingQuantity;

    SerializedOrder(Order order) {
        this.exchange = order.getExchange();
        this.balancingGroupId = order.getBalancingGroupId();
        this.direction = order.getDirection();
        this.accountType = order.getAccount();
        this.contractId = (Long)order.getContract().getId();
        this.deliveryAreaName = order.getDeliveryArea().getName();
        this.orderType = order.getOrderType();
        this.executionRestriction = order.getExecutionRestriction();
        this.validityRestriction = order.getValidityRestriction();
        this.openOrClose = order.getOpenOrClose();
        this.orderStatus = order.getStatus();
        this.limitedPrice = order.getLimitPrice();
        this.remainingQuantity = order.getRemainingQuantity();
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public String getBalancingGroupId() {
        return this.balancingGroupId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public Long getContractId() {
        return this.contractId;
    }

    public String getDeliveryAreaName() {
        return this.deliveryAreaName;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public ExecutionRestriction getExecutionRestriction() {
        return this.executionRestriction;
    }

    public ValidityRestriction getValidityRestriction() {
        return this.validityRestriction;
    }

    public OpenOrClose getOpenOrClose() {
        return this.openOrClose;
    }

    public OrderStatus getOrderStatus() {
        return this.orderStatus;
    }

    public LongDisplayValue getLimitedPrice() {
        return this.limitedPrice;
    }

    public LongDisplayValue getRemainingQuantity() {
        return this.remainingQuantity;
    }

    public static Order getOrder(SerializedOrder serializedOrder, DataModel<String, BalancingGroup> balancingGroupDataModel, DataModel<Long, Contract> contractDataModel, DeliveryAreaQueries deliveryAreaQueries) {
        Order order = new Order();
        order.setId(null);
        order.setBalancingGroup(balancingGroupDataModel.findById(serializedOrder.getBalancingGroupId()));
        order.setDirection(serializedOrder.getDirection());
        order.setAccount(serializedOrder.getAccountType());
        order.setContract(contractDataModel.findById(serializedOrder.getContractId()));
        order.setDeliveryArea(deliveryAreaQueries.findByName(serializedOrder.getDeliveryAreaName()).getFirst().orElse(null));
        order.setOrderType(serializedOrder.getOrderType());
        order.setExecutionRestriction(serializedOrder.getExecutionRestriction());
        order.setValidityRestriction(serializedOrder.getValidityRestriction());
        order.setOpenOrClose(serializedOrder.getOpenOrClose());
        order.setStatus(serializedOrder.getOrderStatus());
        order.setLimitPrice(serializedOrder.getLimitedPrice());
        order.setRemainingQuantity(serializedOrder.getRemainingQuantity());
        return order;
    }

    public static List<Order> getOrders(List<SerializedOrder> serializedOrders, DataModel<String, BalancingGroup> balancingGroupDataModel, DataModel<Long, Contract> contractDataModel, DeliveryAreaQueries deliveryAreaQueries) {
        ArrayList<Order> entries2 = new ArrayList<Order>();
        for (SerializedOrder serializedOrder : serializedOrders) {
            Order order = SerializedOrder.getOrder(serializedOrder, balancingGroupDataModel, contractDataModel, deliveryAreaQueries);
            entries2.add(order);
        }
        return entries2;
    }
}

