/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.module.SenderExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.EulaService;
import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.service.LoginService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileManager;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.FutureExecutor;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;

@Singleton
public class LoginServiceImpl
implements LoginService {
    private final BackendConnectionGateway backendConnectionGateway;
    private final ProfileManager profileManager;
    private final EulaService eulaService;
    private final ExecutorService executorService;
    private final FutureExecutor futureExecutor;

    @Inject
    public LoginServiceImpl(BackendConnectionGateway backendConnectionGateway, ProfileManager profileManager, EulaService eulaService, @SenderExecutor ExecutorService executorService) {
        this.backendConnectionGateway = backendConnectionGateway;
        this.profileManager = profileManager;
        this.eulaService = eulaService;
        this.executorService = executorService;
        this.futureExecutor = new FutureExecutor(executorService);
    }

    @Override
    public Future<Session> login(ConnectionParametersWithFallback connectionParams) {
        SettableFuture<Session> loginResult = SettableFuture.create();
        Consumer<EulaService.EulaDialogResult> handleEulaResult = eulaDialogResult -> this.handleEulaResult((EulaService.EulaDialogResult)((Object)eulaDialogResult), loginResult, connectionParams);
        this.eulaService.showEulaIfNeeded(connectionParams.getUsername(), handleEulaResult);
        return loginResult;
    }

    private void handleEulaResult(EulaService.EulaDialogResult eulaDialogResult, SettableFuture<Session> loginResult, ConnectionParametersWithFallback connectionParams) {
        switch (eulaDialogResult) {
            case ALREADY_AGREED: 
            case NO_EULAS_CONFIGURED: {
                this.doLogin(loginResult, connectionParams);
                break;
            }
            case AGREE: {
                Future<Void> saveProfileFuture = this.profileManager.saveProfile();
                this.futureExecutor.waitForFutureToComplete(saveProfileFuture, nothing -> this.doLogin(loginResult, connectionParams), profileException -> this.saveProfileFailed((Exception)profileException, loginResult));
                break;
            }
            case DISAGREE: {
                loginResult.setException(new LoginException("Eula not accepted", LoginException.ErrorType.EULA_NOT_ACCEPTED));
            }
        }
    }

    private void doLogin(SettableFuture<Session> sessionFuture, ConnectionParametersWithFallback connectionParams) {
        this.executorService.execute(() -> {
            try {
                Session session = this.backendConnectionGateway.login(connectionParams);
                sessionFuture.set(session);
            }
            catch (LoginException | RuntimeException e) {
                sessionFuture.setException(e);
            }
        });
    }

    private void saveProfileFailed(Exception exception, SettableFuture<Session> sessionFuture) {
        sessionFuture.setException(new LoginException("Could not save profile after eula was accepted.", exception));
    }
}

