/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.entities.StatusMessageType;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.comxerv.OrderQuoteNotification;
import com.deutscheboerse.comxerv.comtrader.entities.type.SpecialMessage;
import com.deutscheboerse.comxerv.comtrader.service.NamedParameterMessageFormat;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMessageBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(StatusMessageBuilder.class);
    private final Map<String, Object> params;
    private final StatusMessageType messageType;
    private SpecialMessage specialMessage;

    private StatusMessageBuilder(StatusMessageType messageType) {
        this.messageType = messageType;
        this.params = new HashMap<String, Object>();
    }

    public static StatusMessageBuilder publicMessage(StatusMessageType messageType) {
        return new StatusMessageBuilder(messageType);
    }

    public StatusMessageType getMessageType() {
        return this.messageType;
    }

    public StatusMessageBuilder with(String text) {
        this.params.put("text", text);
        return this;
    }

    public StatusMessageBuilder with(User user) {
        this.params.put("member", user.getMember().getId());
        this.params.put("traderId", user.getUserCode());
        return this;
    }

    public StatusMessageBuilder with(OrderQuoteNotification orderQuoteNotification) {
        this.with(orderQuoteNotification.getContract());
        this.with(orderQuoteNotification.getDeliveryArea());
        this.params.put("quantity", orderQuoteNotification.getQuantity().getDisplayValue().toString());
        this.params.put("direction", Util.getLabel(orderQuoteNotification.getDirection().getLabelKey()));
        this.with(orderQuoteNotification.getTimestmp());
        return this;
    }

    public StatusMessageBuilder with(DateTime date) {
        DateTimeFormatter fmt = DateTimeFormat.forPattern("yyyy.MM.dd HH:mm");
        this.params.put("YYYY_MM_DD_MMHH_FORMATTED_DATE1", fmt.print(date));
        return this;
    }

    public StatusMessageBuilder with(Interval interval) {
        DateTimeFormatter fmt = DateTimeFormat.forPattern("yyyy.MM.dd HH:mm");
        this.params.put("YYYY_MM_DD_MMHH_FORMATTED_DATE1", fmt.print(interval.getStart()));
        this.params.put("YYYY_MM_DD_MMHH_FORMATTED_DATE2", fmt.print(interval.getEnd()));
        return this;
    }

    public StatusMessageBuilder withOnBehalf(String user) {
        if (user != null) {
            this.params.put("onBehalfUser", user);
        }
        return this;
    }

    public StatusMessageBuilder with(LongDisplayValue price) {
        this.params.put("price", price.getDisplayValue().toString());
        return this;
    }

    public StatusMessageBuilder withQuantity(LongDisplayValue quantity) {
        this.params.put("quantity", quantity.getDisplayValue().toString());
        return this;
    }

    public StatusMessageBuilder with(Order oldOrder, Order order) {
        this.params.put("direction", Util.getLabel(order.getDirection().getLabelKey()));
        this.params.put("price", order.getLimitPrice().getDisplayValue().toString());
        if (oldOrder != null) {
            this.params.put("matchedQuantity", oldOrder.getRemainingQuantity().getDisplayValue().subtract(order.getRemainingQuantity().getDisplayValue()).toString());
        } else {
            this.params.put("matchedQuantity", order.getInitialQuantity().getDisplayValue().toString());
        }
        if (order.getBalancingGroup() != null) {
            this.params.put("balancingGroup", order.getBalancingGroup().getDisplayName());
        }
        if (order.getPreArrangedBalancingGroup() != null) {
            this.params.put("preArrangedBalancingGroup", order.getPreArrangedBalancingGroup().getDisplayName());
        }
        this.params.put("quantity", order.getRemainingQuantity().getDisplayValue().toString());
        this.with(order.getDeliveryArea());
        this.with(order.getContract());
        return this;
    }

    public StatusMessageBuilder with(PublicTradeConfirmation publicTradeConfirmation) {
        this.params.put("price", publicTradeConfirmation.getPrice().getDisplayValue().toString());
        this.params.put("quantity", publicTradeConfirmation.getQuantity().getDisplayValue().toString());
        this.params.put("buy_ma", this.getMarketAreaDisplayName(publicTradeConfirmation.getBuyDeliveryArea()));
        this.params.put("sell_ma", this.getMarketAreaDisplayName(publicTradeConfirmation.getSellDeliveryArea()));
        this.with(publicTradeConfirmation.getContract());
        return this;
    }

    private String getMarketAreaDisplayName(DeliveryArea da) {
        if (da == null) {
            return "?";
        }
        if (da.getMarketArea() == null) {
            return da.getMarketAreaId();
        }
        return da.getMarketArea().getDisplayName();
    }

    public StatusMessageBuilder with(Trade trade) {
        this.params.put("price", trade.getPrice().getDisplayValue().toString());
        this.params.put("quantity", trade.getQuantity().getDisplayValue().toString());
        this.with(trade.getContract());
        return this;
    }

    public StatusMessageBuilder with(HalfTrade halfTrade) {
        this.with((Trade)halfTrade);
        this.with(halfTrade.getOrder().getDeliveryArea());
        return this;
    }

    public StatusMessageBuilder with(Product product) {
        this.params.put("currency", product.getCurrencyCode());
        this.params.put("quantityUnit", product.getQuantityUnit());
        this.params.put("productGroupName", product.getGroupName());
        return this;
    }

    public StatusMessageBuilder with(List<DeliveryArea> deliveryAreas) {
        this.params.put("deliveryAreas", deliveryAreas.stream().map(DeliveryArea::getDisplayName).collect(Collectors.joining(", ")));
        return this;
    }

    public StatusMessageBuilder with(Contract contract) {
        this.params.put("contract", contract.getDisplayName());
        this.with(contract.getProduct());
        return this;
    }

    public StatusMessageBuilder with(DeliveryArea deliveryArea) {
        this.params.put("deliveryAreaShort", deliveryArea.getDisplayName());
        return this;
    }

    public StatusMessageBuilder withSpecialMessage(SpecialMessage specialMessage) {
        this.specialMessage = specialMessage;
        return this;
    }

    public SpecialMessage getSpecialMessage() {
        return this.specialMessage;
    }

    public String build() {
        try {
            return NamedParameterMessageFormat.format(Util.getLabel(this.messageType.getKey()), this.params);
        }
        catch (IllegalArgumentException i) {
            LOG.error("Error while parsing \"{}\" with \"{}\"", (Object)Util.getLabel(this.messageType.getKey()), (Object)this.params);
            return null;
        }
    }
}

